@extends('admin.layout.main')
@section('content')
<style>
.btn-remove {
    color: #fff;
    background-color: #fa626b;
}
#custmer_contact_detail_list td{
    padding: 5px;
}
#custmer_contact_detail_list td .form-control {
    color: #000000;
    border: 1px solid #e3e3e3;
    padding: 2px 10px;
}
.more_phonecode_block span.select2.select2-container.select2-container--default {
    float: left;
}
#contact_detail_Modal span.select2.select2-container.select2-container--default {
    float: left;
}
.modal-open .select2-container{
    z-index: 999999;
}
.modal-open .contact_detail_block .select2-container{
    z-index: 999;
}
</style>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($data)) 
                        Edit 
                    @else 
                        Add 
                    @endif
                    Company Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('company.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($data)){{ route('company.update',$data->id) }} @else{{ route('company.store') }}@endif">
                                        @csrf
                                        @if(isset($data))
                                            <input type="hidden" name="id" value="{{ $data->id }}" />
                                        @endif
                                        <div class="form-body">	
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Name<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="name" class="form-control" name="name" value="{{{ old('name', isset($data) ? $data->name : null) }}}">
                                                    @if ($errors->has('name')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('name') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="address">Address line 1<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <textarea id="address" class="form-control" name="address">{{{ old('address', isset($data) ? $data->address : null) }}}</textarea>
                                                    @if ($errors->has('address')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('address') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="address_2">Address line 2</label>
                                                <div class="col-md-9">
                                                    <textarea id="address_2" class="form-control" name="address_2">{{{ old('address_2', isset($data) ? $data->address_2 : null) }}}</textarea>
                                                    @if ($errors->has('address_2')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('address_2') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="address_3">Address line 3</label>
                                                <div class="col-md-9">
                                                    <textarea id="address_3" class="form-control" name="address_3">{{{ old('address_3', isset($data) ? $data->address_3 : null) }}}</textarea>
                                                    @if ($errors->has('address_3')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('address_3') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Country<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select"  id="country_id" name="country_id">
                                                        <option value="">Select Country</option>
                                                        @if(is_object($country))
                                                            @foreach ($country as $value)
                                                            <option value="{{$value->id}}"
                                                            @if(old('country_id', isset($data) ? $data->country_id : null) == $value->id) selected @elseif($value->name == 'India') selected @endif>{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('country_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('country_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">State<span class="required">*</span></label>
                                                <div class="col-md-9" id="state_section">
                                                    <select class="select2-size-lg form-control large-select"  id="state_id" name="state_id">
                                                        
                                                    </select>
                                                    @if ($errors->has('state_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('state_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="phone_number">Mobile Number<span class="required">*</span></label>
                                                <div class="col-md-2">
                                                    <select class="select2-size-lg form-control large-select"  id="phonecode" name="phonecode">
                                                        <option value="">Select Phone Code</option>
                                                        @if(is_object($countryphonecode) && count($countryphonecode) > 0)
                                                            @foreach($countryphonecode as $countryphonecode_val)
                                                                <option value="{{$countryphonecode_val->id}}" @if(old('phonecode', isset($data) ? $data->phonecode_id : null) == $countryphonecode_val->id) selected @endif>{{$countryphonecode_val->phonecode}} ({{$countryphonecode_val->name}})</option>
                                                            @endforeach 
                                                        @endif    
                                                    </select>
                                                    @if ($errors->has('phonecode')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('phonecode') }}</div>
                                                    @endif
                                                </div>
                                                <div class="col-md-7">
                                                    <input type="number" id="phone_number" class="form-control" name="phone_number" value="{{{ old('phone_number', isset($data) ? $data->phone_number : null) }}}">
                                                    @if ($errors->has('phonecode')) 
                                                    @elseif ($errors->has('phone_number')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('phone_number') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="email_address">Email<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="email" id="email_address" class="form-control" name="email_address" value="{{{ old('email_address', isset($data) ? $data->email_address : null) }}}">
                                                    @if ($errors->has('email_address')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('email_address') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="logo_image">Logo Image<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="file" id="logo_image" class="form-control" name="logo_image">
                                                    <p>Only .png, .jpg, .jpeg files are allowed</p>
                                                    @if(isset($data))
                                                        @if($data->logo_image != '')
                                                            <?php 
                                                            $logo_image = $destinationPath.$data->logo_image;
                                                            ?>
                                                            @if(file_exists($logo_image))
                                                            <img src="{{url('/') .'/'.$logo_image}}" width="100" height="100" >
                                                            @endif
                                                        @endif
                                                    @endif
                                                    @if ($errors->has('logo_image')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('logo_image') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <input type="hidden" id="sequence" class="form-control" name="sequence" value="1">
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Save & Exit">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Save">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">
function fun_frm_submit(){
    $('.loader_block').show();
}
$(document).ready(function() {
    $('#country_id').select2({
        placeholder: "Select Country", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
    $('#state_id').select2({
        placeholder: "Select State", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
    $('#phonecode').select2({
        placeholder: "Select Phone Code", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
});
function getState(country_id,state_id=null){
    if(country_id){
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url : "{{ url('getState') }}" +'/'+ country_id,        
            type : 'GET',
            dataType : 'json',
            beforeSend : function(data){
                $('.loader_block').show();
            }
        }).done(function(data) {
        // Code to execute if the request is successfulbeforeSend
            $('#state_id').empty();
            $('#state_id').append('<option value="">Select State</option>');
            $.each(data, function(key, state) {
                var selected = state.id == state_id ? 'selected' : '';
                $('#state_id').append('<option value="' + state.id + '" '+selected+ '>' + state.name + '</option>');
            });
            $('#state_id').prop('disabled', false);
            $('.loader_block').hide();
            
        }).fail(function(jqXHR, textStatus, errorThrown) {
        // Code to execute if the request fails
            console.error("Request failed: " + textStatus);
        });
    } else {
        $('#state_id').empty();
        $('#state_id').append('<option value="">Select State</option>');
        $('#state_id').prop('disabled', true);
        $('.loader_block').hide();
    }
}
$('#country_id').on('change',function(){
    var country_id = this.value;
    getState(country_id);
    phonecode = $('#phonecode').val();
    if(phonecode == ''){
        $("#phonecode").val(country_id).trigger('change');
    }
});
$('#state_id').on('change',function(){
    var state_id = this.value;
});

@if(old('country_id'))
    getState('{{old("country_id")}}','{{old("state_id")}}');
@elseif(isset($data) && $data->country_id)
    getState('{{$data->country_id}}','{{$data->state_id}}');
@else
    getState('1');
@endif
</script>
@endsection
