@extends('admin.layout.main')
@section('content')
<style>
    .ck-editor__editable_inline {
    max-height: 400px !important;
}
</style>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($data)) 
                        Edit 
                    @else 
                        Add 
                    @endif
                    Content Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('content.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($data)){{ route('content.update',$data->id) }} @else{{ route('content.store') }}@endif">
                                        @csrf
                                        @if(isset($data))
                                            <input type="hidden" name="id" value="{{ $data->id }}" />
                                        @endif
                                        <div class="form-body">	                    		
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="page_name">Page Name<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="page_name" class="form-control" name="page_name" @if(!empty($data->page_name)) readonly @endif value="{{{ old('page_name', isset($data) ? $data->page_name : null) }}}">
                                                    @if ($errors->has('page_name')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('page_name') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="page_title">Page Title<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="page_title" class="form-control" name="page_title" value="{{{ old('page_title', isset($data) ? $data->page_title : null) }}}">
                                                    @if ($errors->has('page_title')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('page_title') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="content">Content</label>
                                                <div class="col-md-9">
                                                    <textarea id="content" class="form-control ckeditor" cols="5" name="content">{{{ old('content', isset($data) ? $data->content : null) }}}</textarea>
                                                    @if ($errors->has('content')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('content') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Save & Exit">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Save">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">
function fun_frm_submit(){
    $('.loader_block').show();
}
</script>
<script src="https://cdn.ckeditor.com/ckeditor5/41.4.2/classic/ckeditor.js"></script>
<script>
ClassicEditor
    .create( document.querySelector( '#content' ) )
    .then( editor => {
             window.editor = editor;
            const imageBtn = document.querySelector('.ck-file-dialog-button');
            imageBtn.style.display = 'none';
    } )
    .catch( error => {
            console.error( error );
    } );
    
    ClassicEditor.replace( 'content',
     {
          toolbar : 'simple'
     })
</script>
@endsection
