@extends('admin.layout.main')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-4 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($country))
                    Edit
                    @else
                    Add
                    @endif
                    Country Management
                </h3>
            </div>
            <div class="content-header-right col-md-8 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('country.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">

                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($country)){{ route('country.update',$country->id) }} @else{{ route('country.store') }}@endif">
                                        @csrf
                                        @if(isset($country))
                                        @method('PUT')
                                        <input type="hidden" name="id" value="{{ $country->id }}" />
                                        @endif
                                        <div class="form-body">
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Country Name<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" autocomplete="off" id="name" class="form-control input-suggestion" name="name" value="{{{ old('name', isset($country) ? $country->name : null) }}}">
                                                    @if(is_object($countries) && count($countries) > 0)
                                                    <datalist role="listbox" class="suggetion-datalist">
                                                        @foreach($countries as $country_val)
                                                        <option value="{{ $country_val->name }}">{{$country_val->name}}</option>
                                                        @endforeach
                                                    </datalist>
                                                    @endif
                                                    @if ($errors->has('name'))
                                                    <div class="errors_msg text-danger">{{ $errors->first('name') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="phonecode">Phone Code</label>
                                                <div class="col-md-6">
                                                    <input type="text" id="phonecode" class="form-control" name="phonecode" value="{{{ old('phonecode', isset($country) ? $country->phonecode : null) }}}">
                                                    @if ($errors->has('phonecode')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('phonecode') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="phonecodedigit">Phone Code Digit</label>
                                                <div class="col-md-6">
                                                    <input type="number" id="phonecodedigit" min="0" class="form-control" name="phonecodedigit" value="{{{ old('phonecodedigit', isset($country) ? $country->phonecodedigit : null) }}}">
                                                    @if ($errors->has('phonecodedigit')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('phonecodedigit') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="phonecodestatus">Phone Code Status</label>
                                                <div class="col-md-6">
                                                    <input type="checkbox" id="phonecodestatus" class="form-control1" name="phonecodestatus" value="1"
                                                    @if(old('phonecodestatus') != '')
                                                        @if(old('phonecodestatus') == 1)
                                                            checked
                                                        @endif
                                                    @elseif(isset($country))
                                                        @if($country->phonecodestatus == 1)
                                                            checked
                                                        @endif
                                                    @endif
                                                    >
                                                    @if ($errors->has('phonecodestatus')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('phonecodestatus') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <!-- <div class="form-group row">
                                                <label class="col-md-2 label-control" for="sequence">Sort order<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="number" id="sequence" class="form-control" name="sequence" value="{{{ old('sequence', isset($country) ? $country->sequence : null) }}}">
                                                    @if ($errors->has('sequence')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('sequence') }}</div>
                                                    @endif
                                                </div>
                                            </div> -->
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Save & Exit">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Save">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">
    function fun_frm_submit() {
        error = 0;
        $('.loader_block').show();
    }
</script>
@endsection