@extends('admin.layout.main')
@section('content')
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-4 col-12 mb-2">
                <h3 class="content-header-title">Country Management</h3>
            </div>
            <div class="content-header-right col-md-8 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('country.create') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red add_btn btn-sm"><i class="fa fa-plus" aria-hidden="true"></i> Add</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                             
                        </div>
                        <div class="row">
                            <div class="col-md-12 card-content collapse show" style="background-color: #ffffff;">
                                <div class="table-responsive">
                                    <div class="bd-example">
                                        <table class="table table-responsive-lg" id="table_view" style="text-align: center;">
                                            <thead>
                                                <tr>
                                                    <th scope="col">Country Name</th>
                                                    <th scope="col">Phone Code</th>
                                                    <th scope="col">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script type="text/javascript">
$(function() {
    var table = $('#table_view').DataTable({
        processing: true,
        serverSide: true,
        pageLength: '{{config("constants.PAR_PAGE_LENGHT")}}',
        ajax: "{{ route('country.index') }}",
        columns: [
        {
            data: 'name',
            name: 'name',
            className: 'text-left'
        },
        {
            data: 'phonecode',
            name: 'phonecode',
            className: 'text-left'
        },
        {
            data: 'action',
            name: 'action',
            orderable: false,
            searchable: false,
            className: 'text-left'
        },
        ]
    });
});
</script>
@endsection
