@extends('admin.layout.main')
@section('content')
<style>
    .form-check {
        margin-bottom: 6px !important;
    }
</style>
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-4 col-12 mb-2">
                <h3 class="content-header-title">Customer Track</h3>
            </div>
            <div class="content-header-right col-md-8 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                            <a href="{{ route('customer.user.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="row">
                            <div class="col-md-12 card-content collapse show" style="background-color: #ffffff;">
                                <div class="table-responsive">
                                    <div class="bd-example">
                                        <table class="table table-responsive-lg" id="document_table_view" style="text-align: center;">
                                            <thead>
                                            <tr>
                                                <th scope="col">
                                                    <select class="form-control" id="filter_reminder_type" name="filter_reminder_type[]" style="width: 250px;">
                                                        <option value="">All</option>
                                                        @if(is_object($reminder_type_list))
                                                            @foreach ($reminder_type_list as $value)
                                                            <?php $selected = ''; ?>
                                                            @if($search_reminder_type == $value->name)
                                                                <?php $selected = 'selected'; ?>
                                                            @endif
                                                            <option value="{{$value->name}}" {{$selected}}>{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif 
                                                    </select>
                                                </th>
                                                <th scope="col">
                                                    <select class="form-control" id="filter_reminder_id" name="filter_reminder_id[]" style="width: 250px;">
                                                        <option value="">All</option>
                                                        @if(is_object($reminder_list))
                                                            @foreach ($reminder_list as $value)
                                                            <?php $selected = ''; ?>
                                                            @if($search_reminder_id == $value->id)
                                                                <?php $selected = 'selected'; ?>
                                                            @endif
                                                            <option value="{{$value->id}}" {{$selected}}>{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif 
                                                    </select>
                                                </th>
                                                <th scope="col">
                                                    <select class="form-control" id="filter_document_id" name="filter_document_id[]" style="width: 250px; display:none;">
                                                        <option value="">All</option>
                                                        @if(is_object($document_list))
                                                            @foreach ($document_list as $value)
                                                            <?php $selected = ''; ?>
                                                            @if($search_document_id == $value->id)
                                                                <?php $selected = 'selected'; ?>
                                                            @endif
                                                            <option value="{{$value->id}}" {{$selected}}>{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif 
                                                    </select>
                                                </th>
                                                <th scope="col"></th>
                                                <th scope="col"></th>
                                            </tr>
                                                <tr>
                                                    <th scope="col">Type</th>
                                                    <th scope="col">Reminder</th>
                                                    <th scope="col">List Of Document</th>
                                                    <th scope="col">Send Date</th>
                                                    <th scope="col">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script type="text/javascript">
    var table = $('#document_table_view').DataTable({
        processing: true,
        serverSide: true,
        pageLength: '{{config("constants.PAR_PAGE_LENGHT")}}',
        //ajax: "{{ route('customer.user.emailtrack',$customer_id) }}",
        "ajax": {
            url: "{{ route('customer.user.emailtrack',$customer_id) }}",
            data: function (d) {
                d.filter_reminder_id = jQuery("#filter_reminder_id").val();
                d.filter_reminder_type = jQuery("#filter_reminder_type").val();
                d.filter_document_id = jQuery("#filter_document_id").val();
            },
        },
        aaSorting: [],
        aoColumnDefs: [{
            bSortable: true,
            sType: "numeric",
            aTargets: [0],
            /*mRender: function(data, type) {
                var color = data['color'] != null && data['color'] != ''  ? data['color'] : '' ;
                var status = data['status'] != null && data['status'] != '' ? data['status'] : '';
                var html = '<span class="badge badge-'+color+' font-medium-1">'+status+'</span>';
                return html;
            },*/
        }],
        columns: [{
                data: 'mail_type',
                name: 'mail_type',
                className: 'text-left'
            },{
                data: 'reminder_name',
                name: 'reminder_name',
                className: 'text-left'
            },
            {
                data: 'list_of_document',
                name: 'list_of_document',
                className: 'text-left'
            },
            {
                data: 'send_date',
                name: 'send_date',
                className: 'text-left'
            },
            {
                data: 'action',
                name: 'action',
                className: 'text-left'
            },
        ]
    });
    $('#filter_reminder_id').on('change', function(e) {
        e.preventDefault();
        table.draw();
    });
    $('#filter_reminder_type').on('change', function(e) {
        e.preventDefault();
        table.draw();
    });
    $('#filter_document_id').on('change', function(e) {
        e.preventDefault();
        table.draw();
    });
</script>
<script type="text/javascript">
$(document).ready(function() {
    $('#filter_reminder_id').select2({
        placeholder: "All Reminder", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
    $('#filter_reminder_type').select2({
        placeholder: "All Type", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
});
</script>
@endsection