@extends('admin.layout.main')
@section('content')
<style>
.btn-remove {
    color: #fff;
    background-color: #fa626b;
}
#custmer_contact_detail_list td{
    padding: 5px;
}
#custmer_contact_detail_list td .form-control {
    color: #000000;
    border: 1px solid #e3e3e3;
    padding: 2px 10px;
}
.more_phonecode_block span.select2.select2-container.select2-container--default {
    float: left;
}
#contact_detail_Modal span.select2.select2-container.select2-container--default {
    float: left;
}
.modal-open .select2-container{
    z-index: 999999;
}
.modal-open .contact_detail_block .select2-container{
    z-index: 999;
}
</style>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($data)) 
                        Edit 
                    @else 
                        Add 
                    @endif
                    Customer User Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('customer.user.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($data)){{ route('customer.user.update',$data->id) }} @else{{ route('customer.user.store') }}@endif">
                                        @csrf
                                        @if(isset($data))
                                            <input type="hidden" name="id" value="{{ $data->id }}" />
                                        @endif
                                        <div class="form-body">	
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="group_id">Group<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select"  id="group_id" name="group_id">
                                                        <option value="">Select Group</option>
                                                        @if(is_object($group))
                                                            @foreach ($group as $value)
                                                            <option value="{{$value->id}}"
                                                            @if(old('group_id', isset($data) ? $data->group_id : null) == $value->id) selected @elseif($value->name == 'India') selected @endif>{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('group_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('group_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>                    		
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Name<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="name" class="form-control" name="name" value="{{{ old('name', isset($data) ? $data->name : null) }}}">
                                                    @if ($errors->has('name')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('name') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="address">Address line 1<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <textarea id="address" class="form-control" name="address">{{{ old('address', isset($data) ? $data->address : null) }}}</textarea>
                                                    @if ($errors->has('address')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('address') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="address_2">Address line 2</label>
                                                <div class="col-md-9">
                                                    <textarea id="address_2" class="form-control" name="address_2">{{{ old('address_2', isset($data) ? $data->address_2 : null) }}}</textarea>
                                                    @if ($errors->has('address_2')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('address_2') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="address_3">Address line 3</label>
                                                <div class="col-md-9">
                                                    <textarea id="address_3" class="form-control" name="address_3">{{{ old('address_3', isset($data) ? $data->address_3 : null) }}}</textarea>
                                                    @if ($errors->has('address_3')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('address_3') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Country<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select"  id="country_id" name="country_id">
                                                        <option value="">Select Country</option>
                                                        @if(is_object($country))
                                                            @foreach ($country as $value)
                                                            <option value="{{$value->id}}"
                                                            @if(old('country_id', isset($data) ? $data->country_id : null) == $value->id) selected @elseif($value->name == 'India') selected @endif>{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('country_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('country_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">State<span class="required">*</span></label>
                                                <div class="col-md-9" id="state_section">
                                                    <select class="select2-size-lg form-control large-select"  id="state_id" name="state_id">
                                                        
                                                    </select>
                                                    @if ($errors->has('state_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('state_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row" style="display:none;">
                                                <label class="col-lg-2 col-md-4 label-control" for="city_id">City</label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select" id="city_id" name="city_id">
                                                        
                                                    </select>
                                                    @if ($errors->has('city_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('city_id') }}</div>
                                                    @endif 
                                                </div>
                                            </div>
                                            <div class="form-group row" style="display:none;">
                                                <label class="col-md-2 label-control" for="district">District</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="district" id="district" class="form-control" value="{{ old('district', !empty($data->district) ? $data->district : '') }}">
                                                    @if ($errors->has('district'))
                                                    <div class="errors_msg text-danger">{{ $errors->first('district') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row" style="display:none;">
                                                <label class="col-md-2 label-control" for="pincode_number">Pin Code Number</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="pincode_number"  id="pincode_number" class="form-control" value="{{ old('pincode_number', !empty($data->pincode_number) ? $data->pincode_number : '') }}"><!-- pattern="/^-?\d+\.?\d*$/" onKeyPress="if(this.value.length==6) return false;" -->
                                                    @if ($errors->has('pincode_number'))
                                                    <div class="errors_msg text-danger">{{ $errors->first('pincode_number') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="phone_number">Mobile Number<span class="required">*</span></label>
                                                <div class="col-md-2">
                                                    <select class="select2-size-lg form-control large-select"  id="phonecode" name="phonecode">
                                                        <option value="">Select Phone Code</option>
                                                        @if(is_object($countryphonecode) && count($countryphonecode) > 0)
                                                            @foreach($countryphonecode as $countryphonecode_val)
                                                                <option value="{{$countryphonecode_val->id}}" @if(old('phonecode', isset($data) ? $data->phonecode_id : null) == $countryphonecode_val->id) selected @endif>{{$countryphonecode_val->phonecode}} ({{$countryphonecode_val->name}})</option>
                                                            @endforeach 
                                                        @endif    
                                                    </select>
                                                    @if ($errors->has('phonecode')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('phonecode') }}</div>
                                                    @endif
                                                </div>
                                                <div class="col-md-7">
                                                    <input type="number" id="phone_number" class="form-control" name="phone_number" value="{{{ old('phone_number', isset($data) ? $data->phone_number : null) }}}">
                                                    @if ($errors->has('phonecode')) 
                                                    @elseif ($errors->has('phone_number')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('phone_number') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="email_address">Email<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="email" id="email_address" class="form-control" name="email_address" value="{{{ old('email_address', isset($data) ? $data->email_address : null) }}}">
                                                    @if ($errors->has('email_address')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('email_address') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="year_end">Year End Date</label>
                                                <div class="col-md-9">
                                                    <input type="date" id="year_end" class="form-control" name="year_end" value="{{{ old('year_end', isset($data) ? $data->year_end : null) }}}">
                                                    @if ($errors->has('year_end')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('year_end') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row" style="display:none;">
                                                <label class="col-md-2 label-control" for="name">Password @if(empty($data->id))<span class="required">*</span>@endif</label>
                                                <div class="col-md-9">
                                                    <input type="text" id="password" class="form-control" name="password" value="123456">
                                                    @if(!empty($data->id))
                                                        <span>If you enter the password, it will update; otherwise, it will not.</span>
                                                    @endif
                                                    @if ($errors->has('password')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('password') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <input type="hidden" id="sequence" class="form-control" name="sequence" value="1">
                                            <?php /*
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="sequence">Sort order<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="number" id="sequence" class="form-control" name="sequence" value="{{{ old('sequence', isset($data) ? $data->sequence : null) }}}">
                                                    @if ($errors->has('sequence')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('sequence') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            */?>
                                            <div class="form-group row form-actions contact_detail_block">
                                                <label class="col-md-12 label-control" for="name"><h3>Contact Detail</h3></label>
                                                <div class="col-md-12 row">
                                                    @if ($errors->has('contact_detail')) 
                                                        <div class="errors_msg text-danger col-sm-12">{{ $errors->first('contact_detail') }}</div>
                                                    @endif
                                                    <div class="col-sm-2">
                                                        <div class="form-group">
                                                            <label class=""><strong>Name<span class="required">*</span></strong></label>
                                                            <input type="text" name="more_name" id="more_name" class="form-control" placeholder="" autocomplete="off" value="{{ old('more_name')}}">
                                                            <span class="form_error error_msg text-danger" id="error_more_name"></span>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-2">
                                                        <div class="form-group">
                                                            <label class=""><strong>Email<span class="required">*</span></strong></label>
                                                            <input type="text" name="more_email" id="more_email" class="form-control" placeholder="" autocomplete="off" value="{{ old('more_email')}}">
                                                            <span class="form_error error_msg text-danger" id="error_more_email"></span>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-2">
                                                        <div class="form-group">
                                                            <label class=""><strong>Birth Date</strong></label>
                                                            <input type="date" name="more_birth_date" id="more_birth_date" class="form-control" placeholder="" autocomplete="off" value="{{ old('more_birth_date')}}">
                                                            <span class="form_error error_msg text-danger" id="error_more_birth_date"></span>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4 more_phonecode_block">
                                                        <div class="form-group">
                                                            <label class="col-sm-12"><strong>Mobile Number</strong></label>
                                                            <select class="select2-size-lg form-control large-select"  id="more_phonecode" name="more_phonecode" style="width: 35%;padding: 0px 0px 0px 3px;float: left;">
                                                                <option value="">Select Phone Code</option>
                                                                @if(is_object($countryphonecode) && count($countryphonecode) > 0)
                                                                    @foreach($countryphonecode as $countryphonecode_val)
                                                                        <option value="{{$countryphonecode_val->id}}" @if(old('more_phonecode') == $countryphonecode_val->phonecode) selected @endif>{{$countryphonecode_val->phonecode}} ({{$countryphonecode_val->name}})</option>
                                                                    @endforeach 
                                                                @endif    
                                                            </select>
                                                            <input type="number" name="more_mobile_number" id="more_mobile_number" class="form-control" placeholder="" autocomplete="off" value="{{ old('more_mobile_number')}}" style="float: left;width: 61%;margin-left: 5px;">
                                                            <span class="form_error error_msg text-danger" id="error_more_mobile_number"></span>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-2" style="margin-top: 31px;">
                                                        <label class="">&nbsp;&nbsp;</label>
                                                        <button class="btn btn-sm btn-info" id="add_more" onclick="fun_add_more()" type="button"><i class="fa fa-plus"></i>&nbsp;&nbsp;ADD</button>
                                                    </div>
                                                    <table id="custmer_contact_detail_list" class="table table-bordered ">
                                                        <thead>
                                                            <tr>
                                                                <th>Name</th>
                                                                <th>Email</th>
                                                                <th>Birth Date</th>
                                                                <th>Mobile Number</th>
                                                                <th></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                        @if(is_array(Request::old('contact_name')))
                                                            @foreach (Request::old('contact_name') as $key => $contact_name_val)
                                                            <?php 
                                                                    $custmer_contact_detail_id_val = old('custmer_contact_detail_id')[$key];
                                                                    $contact_email_val = old('contact_email')[$key];
                                                                    $contact_birth_date_val = old('contact_birth_date')[$key];
                                                                    $contact_phonecode_val_val = old('contact_phonecode_val')[$key];
                                                                    $contact_phonecode_val = old('contact_phonecode')[$key];
                                                                    $contact_mobile_number_val = old('contact_mobile_number')[$key];
                                                                ?>
                                                                <tr class="custmer_contact_detail_block" id="custmer_contact_detail_block_{{$key}}">
                                                                    <td>
                                                                        <input type="hidden" name="custmer_contact_detail_id[]" value="<?php echo $custmer_contact_detail_id_val;?>">
                                                                        <input type="text" readonly class="form-control" id="contact_name_{{$key}}" name="contact_name[]" value="<?php echo $contact_name_val;?>"  style="width:98%;" />
                                                                        @if ($errors->has('contact_name.' . $key))
                                                                            <div class="errors_msg text-danger">{{ $errors->first('contact_name.' . $key) }}</div>
                                                                        @endif
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" readonly class="form-control" id="contact_email_{{$key}}" name="contact_email[]" value="<?php echo $contact_email_val;?>"  style="width:98%;"/>
                                                                        @if ($errors->has('contact_email.' . $key))
                                                                            <div class="errors_msg text-danger">{{ $errors->first('contact_email.' . $key) }}</div>
                                                                        @endif
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" readonly class="form-control" id="contact_birth_date_{{$key}}" name="contact_birth_date[]" value="<?php echo $contact_birth_date_val;?>"  style="width:98%;"/>
                                                                        @if ($errors->has('contact_birth_date.' . $key))
                                                                            <div class="errors_msg text-danger">{{ $errors->first('contact_birth_date.' . $key) }}</div>
                                                                        @endif
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" readonly class="form-control" id="contact_phonecode_val_{{$key}}" name="contact_phonecode_val[]" value="<?php echo $contact_phonecode_val_val;?>"  style="width:25%; float:left;"/>
                                                                        <input type="hidden" readonly class="form-control" id="contact_phonecode_{{$key}}" name="contact_phonecode[]" value="<?php echo $contact_phonecode_val;?>"  style="width:25%; float:left;"/>
                                                                        <input type="number" readonly class="form-control" id="contact_mobile_number_{{$key}}" name="contact_mobile_number[]" value="<?php echo $contact_mobile_number_val;?>"  style="width:72%; float:left;margin-left: 5px;"/><br>
                                                                        @if ($errors->has('contact_mobile_number.' . $key))
                                                                            <div class="errors_msg text-danger">{{ $errors->first('contact_mobile_number.' . $key) }}</div>
                                                                        @endif
                                                                        @if ($errors->has('contact_phonecode.' . $key))
                                                                            <div class="errors_msg text-danger">{{ $errors->first('contact_phonecode.' . $key) }}</div>
                                                                        @endif
                                                                    </td>
                                                                    <td>
                                                                        <a href="javascript:;" onclick="fun_edit_contact_detail({{$key}});" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a>
                                                                        <button class="btn btn-sm btn-remove remove_custmer_contact_detail" type="button" data-name="add"><i class="fa fa-minus"></i> &nbsp;Remove</button>
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        @elseif(!empty($contact_detail_list)) 
                                                            @foreach($contact_detail_list as $key=>$contact_detail_list_val) 
                                                            <tr class="custmer_contact_detail_block" id="custmer_contact_detail_block_{{$key}}">
                                                                    <td>
                                                                        <input type="hidden" name="custmer_contact_detail_id[]" value="<?php echo $contact_detail_list_val->id;?>">
                                                                        <input type="text" class="form-control" id="contact_name_{{$key}}" readonly name="contact_name[]" value="<?php echo $contact_detail_list_val->name;?>"  style="width:98%;"/>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" readonly class="form-control" id="contact_email_{{$key}}" name="contact_email[]" value="<?php echo $contact_detail_list_val->email;?>"  style="width:98%;"/>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" readonly class="form-control" id="contact_birth_date_{{$key}}" name="contact_birth_date[]" value="<?php echo $contact_detail_list_val->birth_date;?>"  style="width:98%;"/>
                                                                    </td>
                                                                    <td>
                                                                        <input type="text" readonly class="form-control" id="contact_phonecode_val_{{$key}}" name="contact_phonecode_val[]" value="<?php echo $contact_detail_list_val->phonecode;?>"  style="width:25%; float:left;"/>
                                                                        <input type="hidden" readonly class="form-control" id="contact_phonecode_{{$key}}" name="contact_phonecode[]" value="<?php echo $contact_detail_list_val->phonecode_id;?>"  style="width:25%; float:left;"/>
                                                                        <input type="number" readonly class="form-control" id="contact_mobile_number_{{$key}}" name="contact_mobile_number[]" value="<?php echo $contact_detail_list_val->mobile_number;?>"  style="width:72%; float:left;margin-left: 5px;"/>
                                                                    </td>
                                                                    <td>
                                                                        <a href="javascript:;" onclick="fun_edit_contact_detail({{$key}});" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a>
                                                                        <button class="btn btn-sm btn-remove remove_custmer_contact_detail" type="button" data-name="add"><i class="fa fa-minus"></i> &nbsp;Remove</button>
                                                                    </td>
                                                                </tr>
                                                            @endforeach  
                                                        @endif
                                                        </tbody>
                                                </table>
                                                </div>
                                            </div>
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Save & Exit">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Save">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<div class="modal fade" style="z-index: 106811;" id="contact_detail_Modal" tabindex="-1" role="dialog" aria-labelledby="contact_detail_ModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="assignment_name_block">
                <strong>Contact Detail </strong>
            </h5>    
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="form-body" id="contact_detail_block">
            <div class="card-body">
                <div class="form-group row">
                    <label class="col-md-2 label-control"><strong>Name</strong><span class="required">*</span></label>
                    <div class="col-md-9">
                        <input type="text" name="edit_name" id="edit_name" class="form-control" placeholder="" autocomplete="off" value="">
                        <span class="form_error error_msg text-danger" id="error_edit_name"></span>
                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 label-control"><strong>Email<span class="required">*</span></strong></label>
                    <div class="col-md-9">
                        <input type="text" name="edit_email" id="edit_email" class="form-control" placeholder="" autocomplete="off" value="">
                        <span class="form_error error_msg text-danger" id="error_edit_email"></span>
                    </div>    
                </div>
                <div class="form-group row">
                    <label class="col-md-2 label-control"><strong>Birth Date</strong></label>
                    <div class="col-md-9">
                        <input type="date" name="edit_birth_date" id="edit_birth_date" class="form-control" placeholder="" autocomplete="off" value="">
                        <span class="form_error error_msg text-danger" id="error_edit_birth_date"></span>
                    </div>    
                </div>
                <div class="form-group row">
                    <label class="col-sm-2 label-control"><strong>Mobile Number</strong></label>
                    <div class="col-md-9">
                        <select class="select2-size-lg form-control large-select"  id="edit_phonecode" name="edit_phonecode" style="width: 35%;padding: 0px 0px 0px 3px;float: left;">
                            <option value="">Select Phone Code</option>
                            @if(is_object($countryphonecode) && count($countryphonecode) > 0)
                                @foreach($countryphonecode as $countryphonecode_val)
                                    <option value="{{$countryphonecode_val->id}}">{{$countryphonecode_val->phonecode}} ({{$countryphonecode_val->name}})</option>
                                @endforeach 
                            @endif    
                        </select>
                        <input type="number" name="edit_mobile_number" id="edit_mobile_number" class="form-control" placeholder="" autocomplete="off" value="" style="float: left;width: 62%;margin-left: 5px;">
                        <input type="hidden" name="edit_row_id" id="edit_row_id">
                        <span class="form_error error_msg text-danger" id="error_edit_mobile_number"></span>
                    </div>    
                </div>
            </div>
        </div>
        <div class="modal-footer" style="justify-content: center;">
            <button type="button" class="btn btn-success" onclick="fun_submit_contact_detail();">Submit</button>
            <button type="button" class="btn btn-primary"  data-dismiss="modal">Cancel</button>
        </div>
        </div>
    </div>
</div>
@endsection
@section('js')
<script>
function fun_edit_contact_detail(edit_row_id){
    var edit_name=jQuery('#contact_name_'+edit_row_id).val();
    var edit_email=jQuery('#contact_email_'+edit_row_id).val();
    var edit_birth_date=jQuery('#contact_birth_date_'+edit_row_id).val();
    var edit_phonecode=jQuery('#contact_phonecode_'+edit_row_id).val();
    var edit_mobile_number=jQuery('#contact_mobile_number_'+edit_row_id).val();
    $('#edit_name').val(edit_name);
    $('#edit_email').val(edit_email);
    $('#edit_birth_date').val(edit_birth_date);
    $("#edit_phonecode").val(edit_phonecode).trigger('change');
    $('#edit_mobile_number').val(edit_mobile_number);
    $('#edit_row_id').val(edit_row_id);
    $('#contact_detail_Modal').modal('show');
}  
function fun_submit_contact_detail(){
    jQuery(".error_msg").html("");
    var edit_row_id=jQuery('#edit_row_id').val();
    var edit_name=jQuery('#edit_name').val();
    var edit_email=jQuery('#edit_email').val();
    var edit_birth_date=jQuery('#edit_birth_date').val();
    var edit_phonecode=jQuery('#edit_phonecode').val();
    var edit_mobile_number=jQuery('#edit_mobile_number').val();
    if(!edit_name.trim()){
        jQuery('#error_edit_name').html("Name is required.");
        jQuery('#edit_name').focus();
        return false;
    }
    if(!edit_email.trim()){
        jQuery('#error_edit_email').html("Email is required.");
        jQuery('#edit_email').focus();
        return false;
    }
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url : "{{ url('get_phone_code_validation') }}",      
        data: {'phonecode':edit_phonecode,'mobile_number':edit_mobile_number},  
        type : 'post',
        dataType : 'json',
        beforeSend : function(data){
            //$('.loader_block').show();
        }
    }).done(function(data) {
        if(data.status == 'success'){
            jQuery('#contact_name_'+edit_row_id).val(edit_name);
            jQuery('#contact_email_'+edit_row_id).val(edit_email);
            jQuery('#contact_birth_date_'+edit_row_id).val(edit_birth_date);
            jQuery('#contact_phonecode_val_'+edit_row_id).val(data.phonecode_val);
            jQuery('#contact_phonecode_'+edit_row_id).val(edit_phonecode);
            jQuery('#contact_mobile_number_'+edit_row_id).val(edit_mobile_number);
            $('#contact_detail_Modal').modal('hide');

        }else{
            jQuery('#error_edit_mobile_number').html('<br>'+data.return_msg);
            jQuery('#edit_mobile_number').focus();
        }    
    }).fail(function(jqXHR, textStatus, errorThrown) {
    // Code to execute if the request fails
        console.error("Request failed: " + textStatus);
    });
}  
function fun_add_more(){
    jQuery(".error_msg").html("");
    var more_name=jQuery('#more_name').val();
    if(!more_name.trim()){
        jQuery('#error_more_name').html("Name is required.");
        jQuery('#more_name').focus();
        return false;
    }
    var more_email=jQuery('#more_email').val();
    if(!more_email.trim()){
        jQuery('#error_more_email').html("Email is required.");
        jQuery('#more_email').focus();
        return false;
    }
    var more_birth_date=jQuery('#more_birth_date').val();
    var more_phonecode=jQuery('#more_phonecode').val();
    /*if(!more_phonecode.trim()){
        jQuery('#error_more_mobile_number').html("Phone Code is required.");
        jQuery('#more_phonecode').focus();
        return false;
    }*/
    var more_mobile_number=jQuery('#more_mobile_number').val();
    /*if(!more_mobile_number.trim()){
        jQuery('#error_more_mobile_number').html("Mobile Number is required.");
        jQuery('#more_mobile_number').focus();
        return false;
    }*/
    numItems = $('.custmer_contact_detail_block').length;
    numItems = makeid(5)+numItems + 1;
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url : "{{ url('get_phone_code_validation') }}",      
        data: {'phonecode':more_phonecode,'mobile_number':more_mobile_number},  
        type : 'post',
        dataType : 'json',
        beforeSend : function(data){
            //$('.loader_block').show();
        }
    }).done(function(data) {
        if(data.status == 'success'){
            var html='<tr class="custmer_contact_detail_block" id="custmer_contact_detail_block_'+numItems+'"><td><input type="hidden" name="custmer_contact_detail_id[]" value="0"><input type="text" readonly class="form-control" id="contact_name_'+numItems+'" name="contact_name[]" value="'+more_name+'"  style="width:98%;"/></td><td><input type="text" readonly class="form-control" id="contact_email_'+numItems+'" name="contact_email[]" value="'+more_email+'"  style="width:98%;"/></td><td><input type="text" readonly class="form-control" id="contact_birth_date_'+numItems+'" name="contact_birth_date[]" value="'+more_birth_date+'"  style="width:98%;"/></td><td><input type="text" readonly class="form-control" id="contact_phonecode_val_'+numItems+'" name="contact_phonecode_val[]" value="'+data.phonecode_val+'"  style="width:25%; float:left;"/><input type="hidden" readonly class="form-control" id="contact_phonecode_'+numItems+'" name="contact_phonecode[]" value="'+more_phonecode+'"  style="width:25%; float:left;"/><input type="number" readonly class="form-control" id="contact_mobile_number_'+numItems+'" name="contact_mobile_number[]" value="'+more_mobile_number+'"  style="width:72%; float:left;margin-left: 5px;"/></td><td><a href="javascript:;" onclick="fun_edit_contact_detail('+numItems+');" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a><button class="btn btn-sm btn-remove remove_custmer_contact_detail" type="button" data-name="add"><i class="fa fa-minus"></i> &nbsp;Remove</button></td></tr>';
            jQuery('#custmer_contact_detail_list > tbody').append(html);
            jQuery('#more_name').val('');
            jQuery('#more_email').val('');
            jQuery('#more_birth_date').val('');
            jQuery('#more_phonecode').val('').trigger('change');
            jQuery('#more_mobile_number').val('');
            jQuery('#more_name').focus();
        }else{
            jQuery('#error_more_mobile_number').html('<br>'+data.return_msg);
            jQuery('#more_mobile_number').focus();
        }    
    }).fail(function(jqXHR, textStatus, errorThrown) {
    // Code to execute if the request fails
        console.error("Request failed: " + textStatus);
    });
}
jQuery('form').on('keydown', '#more_name,#more_email,#more_phonecode,#more_mobile_number', function(e) {
	if (e.keyCode == 13) {
		e.preventDefault();
		fun_add_more();
	}
});
jQuery('form').on('click', 'button.remove_custmer_contact_detail', function(e) {
	if (confirm("Are you sure you want to remove this? ")) {
		var currentproduct = jQuery(this).parents("tr.custmer_contact_detail_block");
		currentproduct.remove();
	}
});
function makeid(length) {
   var result           = '';
   var characters       = '0123456789';
   var charactersLength = characters.length;
   for ( var i = 0; i < length; i++ ) {
      result += characters.charAt(Math.floor(Math.random() * charactersLength));
   }
   return result;
}


</script>
<script type="text/javascript">
function fun_frm_submit(){
    $('.loader_block').show();
}
$(document).ready(function() {
    $('#group_id').select2({
        placeholder: "Select Group", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
    $('#country_id').select2({
        placeholder: "Select Country", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
    $('#state_id').select2({
        placeholder: "Select State", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
    $('#city_id').select2({
        placeholder: "Select City", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
    $('#phonecode').select2({
        placeholder: "Select Phone Code", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
    $('#more_phonecode').select2({
        placeholder: "Select Phone Code", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
    $('#edit_phonecode').select2({
        placeholder: "Select Phone Code", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
    
});
function getState(country_id,state_id=null){
    if(country_id){
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url : "{{ url('getState') }}" +'/'+ country_id,        
            type : 'GET',
            dataType : 'json',
            beforeSend : function(data){
                $('.loader_block').show();
            }
        }).done(function(data) {
        // Code to execute if the request is successfulbeforeSend
            $('#state_id').empty();
            if(state_id == null){
                $('#city_id').empty();
            }
            
            $('#state_id').append('<option value="">Select State</option>');
            $.each(data, function(key, state) {
                var selected = state.id == state_id ? 'selected' : '';
                $('#state_id').append('<option value="' + state.id + '" '+selected+ '>' + state.name + '</option>');
            });
            $('#state_id').prop('disabled', false);
            $('.loader_block').hide();
            
        }).fail(function(jqXHR, textStatus, errorThrown) {
        // Code to execute if the request fails
            console.error("Request failed: " + textStatus);
        });
    } else {
        $('#state_id').empty();
        $('#state_id').append('<option value="">Select State</option>');
        $('#state_id').prop('disabled', true);
        $('#city_id').empty();
        $('#city_id').append('<option value="">Select City</option>');
        $('#city_id').prop('disabled', true);
        $('.loader_block').hide();
    }
}

function getCity(state_id,city_id=null){
    /*if(state_id){
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url : "{{ url('getCity') }}" +'/'+ state_id,        
            type : 'GET',
            dataType : 'json',
            beforeSend: function(data) {
                $('.loader_block').show();                
            }
        }).done(function(data) {
        // Code to execute if the request is successful
            $('#city_id').empty();
            $('#city_id').append('<option value="">Select City</option>');
            $.each(data, function(key, city) {
                var selected = city.id == city_id ? 'selected' : '';
                $('#city_id').append('<option value="' + city.id + '" '+selected+ '>' + city.name + '</option>');
            });
            $('#city_id').prop('disabled', false);
            $('.loader_block').hide();
            
        }).fail(function(jqXHR, textStatus, errorThrown) {
        // Code to execute if the request fails
            console.error("Request failed: " + textStatus);
        });
    } else {
        $('#city_id').empty();
        $('#city_id').append('<option value="">Select State</option>');
        $('#city_id').prop('disabled', true);
        $('.loader_block').hide();
    }*/
}

$('#country_id').on('change',function(){
    var country_id = this.value;
    getState(country_id);
    phonecode = $('#phonecode').val();
    if(phonecode == ''){
        $("#phonecode").val(country_id).trigger('change');
    }
    more_phonecode = $('#more_phonecode').val();
    if(more_phonecode == ''){
        $("#more_phonecode").val(country_id).trigger('change');
    }
});
$('#state_id').on('change',function(){
    var state_id = this.value;
    getCity(state_id);
});

@if(old('country_id'))
    getState('{{old("country_id")}}','{{old("state_id")}}');
@elseif(isset($data) && $data->country_id)
    getState('{{$data->country_id}}','{{$data->state_id}}');
@else
    getState('1');
@endif
/* 
@if(old('state_id'))
    getCity('{{old("state_id")}}','{{old("city_id")}}');
@elseif(isset($data) && $data->state_id)
    getCity('{{$data->state_id}}','{{$data->city_id}}');
@endif
*/

</script>
@endsection
