@extends('admin.layout.main')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    Import Customer User
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('customer.user.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="{{ route('customer.user.import') }}">
                                        @csrf
										@if(count($errors) > 0)
<div class="alert alert-danger">
Upload Validation Error<br><br>
<ul>
@foreach($errors->all() as $error)
<li>{{ $error }}</li>
@endforeach
</ul>
</div>
@endif
                                        <div class="form-body">	                    		
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="import_file">Import File<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="file" id="import_file" class="form-control" name="import_file" value="">
                                                    @if ($errors->has('import_file')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('import_file') }}</div>
                                                    @endif
                                                </div>
                                            </div>
											<div class="form-group row">
                                                <label class="col-md-2 label-control" for="">&nbsp;</label>
                                                <div class="col-md-9">
                                                    Simple File <a target="_blank" href="<?php echo url('/').'/excel/simple.xls';?>"> Click Here</a>
                                                </div>
                                            </div>
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Import">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">
function fun_frm_submit(){
    $('.loader_block').show();
}
</script>
@endsection
