@extends('admin.layout.main')
@section('content')
<style>
    div#myTabContent {
    margin-top: 20px;
}
</style>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    View Customer User Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('customer.user.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body view-category-page">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="detail-tab" data-toggle="tab" data-target="#detail" type="button" role="tab" aria-controls="detail" aria-selected="true">Detail</button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="document-tab" data-toggle="tab" data-target="#document" type="button" role="tab" aria-controls="document" aria-selected="false">Document</button>
                                        </li>
                                    </ul>
                                    <div class="tab-content" id="myTabContent">
                                        <div class="tab-pane fade show active" id="detail" role="tabpanel" aria-labelledby="detail-tab">
                                            <form method="POST" enctype="multipart/form-data" action="@if(isset($data)){{ route('city.update',$data->id) }} @else{{ route('city.store') }}@endif">
                                            @csrf
                                            @if(isset($data))
                                                <input type="hidden" name="id" value="{{ $data->id }}" />
                                            @endif
                                            <div class="form-body">	      
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="sequence">Group Name</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('group_id', is_object($data->Group) ? $data->Group->name : null) }}</p>
                                                    </div>
                                                </div>              		
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="name">Name</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('name', isset($data) ? $data->name : null) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="sequence">Email</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('email_address', isset($data) ? $data->email_address : null) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="sequence">Phone Number</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('phone_number', isset($data) ? $data->phone_number : null) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="sequence">Address</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('address', isset($data) ? $data->address : null) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="sequence">Country</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('country_id', is_object($data->Country) ? $data->Country->name : null) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="sequence">State</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('state_id', is_object($data->State) ? $data->State->name : null) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="sequence">City</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('city_id', is_object($data->City) ? $data->City->name : null) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="sequence">District</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('district', isset($data) ? $data->district : null) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="sequence">Pin Code Number</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('pincode_number', isset($data) ? $data->pincode_number : null) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="sequence">Status</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('city_id', is_object($data) && $data->status == 1 ? 'Active' : (is_object($data) && $data->status == 0 ? 'Inactive' : Inactive) ) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row" style="display:none;">
                                                    <label class="col-md-2 label-control" for="sequence">Sort order</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('sequence', isset($data) ? $data->sequence : null) }}</p>
                                                    </div>
                                                </div>
                                                
                                            </div>    
                                        </form>
                                        </div>
                                        <div class="tab-pane fade" id="document" role="tabpanel" aria-labelledby="document-tab">
                                            <div class="table-responsive">
                                                <div class="bd-example">
                                                    <table class="table table-responsive-lg" id="document_uploaded_table" style="text-align: center;">
                                                        <thead>
                                                            <tr>
                                                                <th scope="col">Reminder</th>
                                                                <th scope="col">Document Name</th>
                                                                <th scope="col">Document</th>
                                                                <th scope="col">Date Time</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">
$(function() {
    var table = $('#document_uploaded_table').DataTable({
        processing: true,
        serverSide: true,
        // scrollX : 500,
        // responsive : true,
        pageLength: '{{config("constants.PAR_PAGE_LENGHT")}}',
        ajax: "{{ route('customer.user.document_uploaded',$id) }}",
        columns: [       
        {
            data: 'reminder_name',
            name: 'reminder_name',
            className: 'text-left'
        },
        {
            data: 'document_name',
            name: 'document_name',
            className: 'text-left'
        },
        {
            data: 'document_file',
            name: 'document_file',
            orderable: false,
            searchable: false,
            className: 'text-left'
        },
        {
            data: 'datetime',
            name: 'datetime',
            className: 'text-left'
        },
        ]
    });
});
</script>  
@endsection
