@extends('admin.layout.main')
@section('content')
<style>
    .ck-editor__editable_inline {
    max-height: 600px !important;
    height: 600px !important;
}
#cke_1_contents{
    max-height: 600px !important;
    height: 600px !important;
}
</style>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($data)) 
                        Edit 
                    @else 
                        Add 
                    @endif
                    Document Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('document.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($data)){{ route('document.update',$data->id) }} @else{{ route('document.store') }}@endif">
                                        @csrf
                                        @if(isset($data))
                                            <input type="hidden" name="id" value="{{ $data->id }}" />
                                        @endif
                                        <div class="form-body">
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="assignment_id">Assignment<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select"  id="assignment_id" name="assignment_id">
                                                        <option value="">Select Assignment</option>
                                                        @if(is_object($assignment))
                                                            @foreach ($assignment as $value)
                                                            <option value="{{$value->id}}"
                                                            @if(old('assignment_id', isset($data) ? $data->assignment_id : null) == $value->id) selected @elseif($value->name == 'India') selected @endif>{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('assignment_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('assignment_id') }}</div>
                                                    @endif
                                                </div>
                                            </div> 	 
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="heading_id">Heading<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select"  id="heading_id" name="heading_id">
                                                        <option value="">Select Heading</option>
                                                        @if(is_object($heading))
                                                            @foreach ($heading as $value)
                                                            <option value="{{$value->id}}"
                                                            @if(old('heading_id', isset($data) ? $data->heading_id : null) == $value->id) selected @elseif($value->name == 'India') selected @endif>{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('heading_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('heading_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>                    		
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Name<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="name" class="form-control" name="name" value="{{{ old('name', isset($data) ? $data->name : null) }}}">
                                                    @if ($errors->has('name')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('name') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="description">Description</label>
                                                <div class="col-md-9">
                                                    <textarea id="description" class="form-control" cols="5" name="description">{{{ old('description', isset($data) ? $data->description : null) }}}</textarea>
                                                    @if ($errors->has('description')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('description') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="templete_flage">Templete</label>
                                                <div class="col-md-9">
                                                    <input 
                                                    @if(old('templete_flage', isset($data) ? $data->templete_flage : 0) == '1') checked @elseif($value->templete_flage == '1') checked @endif
                                                    type="checkbox" id="templete_flage" class="form-control1" name="templete_flage" value="1">
                                                    @if ($errors->has('templete_flage')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('templete_flage') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="doc_content">Doc Content</label>
                                                <div class="col-md-9">
                                                    <textarea id="doc_content" class="form-control ckeditor" cols="20" name="doc_content">{{{ old('doc_content', isset($data) ? $data->doc_content : null) }}}</textarea>
                                                    <?php 
                                                    $CLIENTNAME_val = '{{{CLIENTNAME}}}';
                                                    $CLIENTADDRESS_val = '{{{CLIENTADDRESS}}}';
                                                    $CurrentDate_val = '{{{CurrentDate}}}';
                                                    $YearEndDate_val = '{{{YearEndDate}}}';
                                                    ?>
                                                    <p> {{$CLIENTNAME_val}} Replace With Customer User ==> Name</p>
                                                    <p> {{$CLIENTADDRESS_val}} Replace With Customer User ==> Address</p>
                                                    <p> {{$YearEndDate_val}} Replace With Reminder ==> Year End Date</p>
                                                    <p> {{$CurrentDate_val}} Replace With Reminder ==> Current Date</p>
                                                    @if ($errors->has('doc_content')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('doc_content') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Save & Exit">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Save">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">
function fun_frm_submit(){
    $('.loader_block').show();
}
</script>
<!-- <script src="{{asset('app-assets/vendors/js/editors/ckeditor/ckeditor.js')}}" type="text/javascript"></script> -->
<script src="https://demos.themeselection.com/chameleon-admin-template/app-assets/vendors/js/editors/ckeditor/ckeditor.js" type="text/javascript"></script>
<script src="https://demos.themeselection.com/chameleon-admin-template/app-assets/vendors/js/editors/ckeditor/config.js?t=I3I8" type="text/javascript"></script>
<script src="https://demos.themeselection.com/chameleon-admin-template/app-assets/vendors/js/editors/ckeditor/plugins/sourcedialog/lang/en.js?t=I3I8" type="text/javascript"></script>
<link rel="stylesheet" type="text/css" href="https://demos.themeselection.com/chameleon-admin-template/app-assets/vendors/js/editors/ckeditor/skins/moono-lisa/editor.css?t=I3I8">
<script>
    $(document).ready(function () {
                 CKEDITOR.config.removeButtons = 'Image,Save,NewPage,DocProps,Preview,Print,Templates,document,Cut,Copy,Paste,PasteText,PasteFromWord,Undo,Redo,Find,Replace,SelectAll,Scayt,Form,Checkbox,Radio,TextField,Textarea,Select,Button,ImageButton,HiddenField,Anchor,CreatePlaceholder,Flash,HorizontalRule,Smiley,SpecialChar,PageBreak,Iframe,InsertPre,Maximize,ShowBlocks,button1,button2,button3,oembed,MediaEmbed,About,Styles,Format,Font,FontSize'
                 CKEDITOR.addCss('.cke_editable p { margin: 0 !important; }');
                CKEDITOR.replace('doc_content');
            });
            //Image,
            //,Source
            //,Bold,Italic,Underline,Strike,Subscript,Superscript,RemoveFormat,NumberedList,BulletedList,Outdent,Indent,Blockquote,CreateDiv,JustifyLeft,JustifyCenter,JustifyRight,JustifyBlock,BidiLtr,BidiRtl,Link,Unlink
            //,Table
            //,TextColor,BGColor,UIColor
</script>
<!-- <script src="https://cdn.ckeditor.com/ckeditor5/41.4.2/classic/ckeditor.js"></script>
<script>
ClassicEditor
    .create( document.querySelector( '#doc_content' ) )
    .then( editor => {
             window.editor = editor;
            const imageBtn = document.querySelector('.ck-file-dialog-button');
            imageBtn.style.display = 'none';
    } )
    .catch( error => {
            console.error( error );
    } );
    
    ClassicEditor.replace( 'doc_content',
     {
          toolbar : 'simple'
     })
</script> -->
@endsection
