@extends('admin.layout.main')
@section('content')
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">Templete Management</h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                             
                        </div>
                        <div class="row">
                            <div class="col-md-12 card-content collapse show" style="background-color: #ffffff;">
                                <div class="table-responsive">
                                    <div class="bd-example">
                                    <table class="table table-responsive-lg" id="">
                                            <thead>
                                                <tr>
                                                    <th scope="col">Customer</th>
                                                    <th scope="col" style="text-align: left;">Current Date</th>
                                                    <th scope="col" style="text-align: left;">Year End Date</th>
                                                </tr>
                                                <tr>
                                                    <th scope="col">
                                                    <select name="customer_id" id="customer_id" class="form-control">
                                                            <option value="">Select Customer</option>
                                                            @if(is_object($customer_list))
                                                                @foreach ($customer_list as $value)
                                                                    <?php
                                                                    $Groupname = '';
                                                                    if (is_object($value->Group)) {
                                                                        $Groupname = $value->Group->name;
                                                                    }
                                                                    ?>
                                                                    <option value="{{$value->id}}" 
                                                                    @if(isset($all_customer_id_selected))
                                                                        @if(in_array($value->id,$all_customer_id_selected))
                                                                            selected
                                                                        @endif
                                                                    @endif
                                                                    >{{$value->name}} - {{$Groupname}}</option>
                                                                @endforeach  
                                                            @endif 
                                                        </select>
                                                    </th>
                                                    <th scope="col">
                                                        <input type="date" id="current_date_value" class="form-control" name="current_date_value" value="">
                                                    </th>
                                                    <th scope="col">
                                                        <input type="date" id="year_end" class="form-control" name="year_end" value="">
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                        <table class="table table-responsive-lg" id="templete_table" style="text-align: center;">
                                            <thead>
                                                <tr>
                                                    <th scope="col">Assignment</th>
                                                    <th scope="col">Name</th>
                                                    <th scope="col">Description</th>
                                                    <th scope="col">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script type="text/javascript">
$(function() {
    var table = $('#templete_table').DataTable({
        processing: true,
        serverSide: true,
        // scrollX : 500,
        // responsive : true,
        pageLength: '{{config("constants.PAR_PAGE_LENGHT")}}',
        ajax: "{{ route('templete.index') }}",
        columns: [    
        {
            data: 'assignment_name',
            name: 'assignment_name',
            className: 'text-left'
        },   
        {
            data: 'name',
            name: 'name',
            className: 'text-left'
        }, 
        {
            data: 'description',
            name: 'description',
            className: 'text-left'
        },
        {
            data: 'action',
            name: 'action',
            orderable: false,
            searchable: false,
            className: 'text-left'
        },
        ]
    });
});
function fun_templete_create(doc_id){
    href_url = $('#templete_row_'+doc_id).attr('data-href');
    customer_id = $('#customer_id').val();
    current_date_value = $('#current_date_value').val();
    year_end = $('#year_end').val();
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url : href_url+'?action_call=ajax_call',      
        data: {'customer_id':customer_id,'current_date_value':current_date_value,'year_end':year_end},  
        type : 'get',
        dataType : 'json',
        beforeSend : function(data){
            //$('.loader_block').show();
        }
    }).done(function(data) {
        window.open(data.file_name_url,'_blank');
    }).fail(function(jqXHR, textStatus, errorThrown) {
    // Code to execute if the request fails
        console.error("Request failed: " + textStatus);
    });
}
</script>
@endsection
