@extends('admin.layout.main')
@section('content')
<style>
    .ck-editor__editable_inline {
    max-height: 600px !important;
    height: 600px !important;
}
#cke_1_contents{
    max-height: 600px !important;
    height: 600px !important;
}
.image_main_inner_box{
    display: inline-block;
    vertical-align: top;
    position: relative;
    width: 15%;
    margin-right: 30px;
    margin-top: 19px;
    border: 1px solid;
    padding: 10px;
}
.image_delete_block{
    position: absolute;
    right: -5px;
    top: -17px;
}
</style>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($data)) 
                        Edit 
                    @else 
                        Add 
                    @endif
                    Email Content Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('email_content.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($data)){{ route('email_content.update',$data->id) }} @else{{ route('email_content.store') }}@endif">
                                        @csrf
                                        @if(isset($data))
                                            <input type="hidden" name="id" value="{{ $data->id }}" />
                                        @endif
                                        <div class="form-body">	                    		
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="title">Title<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="title" class="form-control" name="title" @if(!empty($data->title)) readonly @endif value="{{{ old('title', isset($data) ? $data->title : null) }}}">
                                                    @if ($errors->has('title')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('title') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="subject">Subject<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="subject" class="form-control" name="subject" value="{{{ old('subject', isset($data) ? $data->subject : null) }}}">
                                                    @if ($errors->has('subject')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('subject') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="content">Content<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <textarea id="content" class="form-control ckeditor" cols="5" name="content">{{{ old('content', isset($data) ? $data->content : null) }}}</textarea>
                                                    @if ($errors->has('content')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('content') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <?php 
                                            $email_content_id = isset($data) ? $data->id : 0;
                                            ?>
                                            @if($email_content_id == config('constants.MAIL_TEMPLATE.Birthday_Wish'))
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="attachment">Attachment</label>
                                                    <div class="col-md-9">
                                                        <input type="file" name="attachment[]" id="attachment" class="form-control" value="" multiple>
                                                        <span>
                                                        <?php
                                                        echo $html = \App\Helper\Helpers::GetEmailAttachment($email_content_id,'form_edit');
                                                        ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            @endif    
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Save & Exit">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Save">
                                                @if($email_content_id == config('constants.MAIL_TEMPLATE.Birthday_Wish'))
                                                    <input class="btn btn-primary submit btn-sm" name="save_send" type="submit" value="Save & Send">
                                                @endif
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">
function fun_frm_submit(){
    $('.loader_block').show();
}
</script>
<!-- <script src="{{asset('app-assets/vendors/js/editors/ckeditor/ckeditor.js')}}" type="text/javascript"></script> -->
<script src="https://demos.themeselection.com/chameleon-admin-template/app-assets/vendors/js/editors/ckeditor/ckeditor.js" type="text/javascript"></script>
<script src="https://demos.themeselection.com/chameleon-admin-template/app-assets/vendors/js/editors/ckeditor/config.js?t=I3I8" type="text/javascript"></script>
<script src="https://demos.themeselection.com/chameleon-admin-template/app-assets/vendors/js/editors/ckeditor/plugins/sourcedialog/lang/en.js?t=I3I8" type="text/javascript"></script>
<link rel="stylesheet" type="text/css" href="https://demos.themeselection.com/chameleon-admin-template/app-assets/vendors/js/editors/ckeditor/skins/moono-lisa/editor.css?t=I3I8">
<script>
    $(document).ready(function () {
                 CKEDITOR.config.removeButtons = 'Save,NewPage,DocProps,Preview,Print,Templates,document,Cut,Copy,Paste,PasteText,PasteFromWord,Undo,Redo,Find,Replace,SelectAll,Scayt,Form,Checkbox,Radio,TextField,Textarea,Select,Button,ImageButton,HiddenField,Anchor,CreatePlaceholder,Flash,HorizontalRule,Smiley,SpecialChar,PageBreak,Iframe,InsertPre,Maximize,ShowBlocks,button1,button2,button3,oembed,MediaEmbed,About,Styles,Format,Font,FontSize'
                 CKEDITOR.addCss('.cke_editable p { margin: 0 !important; }');
                CKEDITOR.replace('content');
            });
            //Image,
            //,Source
            //,Bold,Italic,Underline,Strike,Subscript,Superscript,RemoveFormat,NumberedList,BulletedList,Outdent,Indent,Blockquote,CreateDiv,JustifyLeft,JustifyCenter,JustifyRight,JustifyBlock,BidiLtr,BidiRtl,Link,Unlink
            //,Table
            //,TextColor,BGColor,UIColor
</script>
<!-- <script src="https://cdn.ckeditor.com/ckeditor5/41.4.2/classic/ckeditor.js"></script>
<script>
ClassicEditor
    .create( document.querySelector( '#content' ) )
    .then( editor => {
             window.editor = editor;
            const imageBtn = document.querySelector('.ck-file-dialog-button');
            imageBtn.style.display = 'none';
    } )
    .catch( error => {
            console.error( error );
    } );
    
    ClassicEditor.replace( 'content',
     {
          toolbar : 'simple'
     })
</script> -->
@endsection
