@extends('admin.layout.main')
@section('content')
<style>
.btn-remove {
    color: #fff;
    background-color: #fa626b;
}
#custmer_contact_detail_list td{
    padding: 5px;
}
#custmer_contact_detail_list td .form-control {
    color: #000000;
    border: 1px solid #e3e3e3;
    padding: 2px 10px;
}
.more_phonecode_block span.select2.select2-container.select2-container--default {
    float: left;
}
#contact_detail_Modal span.select2.select2-container.select2-container--default {
    float: left;
}
.modal-open .select2-container{
    z-index: 999999;
}
.modal-open .contact_detail_block .select2-container{
    z-index: 999;
}
</style>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($data)) 
                        Edit 
                    @else 
                        Add 
                    @endif
                    Employee User Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('employee.user.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($data)){{ route('employee.user.update',$data->id) }} @else{{ route('employee.user.store') }}@endif">
                                        @csrf
                                        @if(isset($data))
                                            <input type="hidden" name="id" value="{{ $data->id }}" />
                                        @endif
                                        <div class="form-body">	
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Name<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="name" class="form-control" name="name" value="{{{ old('name', isset($data) ? $data->name : null) }}}">
                                                    @if ($errors->has('name')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('name') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="designation">Designation<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="designation" class="form-control" name="designation" value="{{{ old('designation', isset($data) ? $data->designation : null) }}}">
                                                    @if ($errors->has('designation')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('designation') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="address">Address line 1<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <textarea id="address" class="form-control" name="address">{{{ old('address', isset($data) ? $data->address : null) }}}</textarea>
                                                    @if ($errors->has('address')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('address') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="address_2">Address line 2</label>
                                                <div class="col-md-9">
                                                    <textarea id="address_2" class="form-control" name="address_2">{{{ old('address_2', isset($data) ? $data->address_2 : null) }}}</textarea>
                                                    @if ($errors->has('address_2')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('address_2') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="address_3">Address line 3</label>
                                                <div class="col-md-9">
                                                    <textarea id="address_3" class="form-control" name="address_3">{{{ old('address_3', isset($data) ? $data->address_3 : null) }}}</textarea>
                                                    @if ($errors->has('address_3')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('address_3') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row" style="display:none;">
                                                <label class="col-md-2 label-control" for="pincode_number">Pin Code Number</label>
                                                <div class="col-md-9">
                                                    <input type="text" name="pincode_number"  id="pincode_number" class="form-control" value="{{ old('pincode_number', !empty($data->pincode_number) ? $data->pincode_number : '') }}"><!-- pattern="/^-?\d+\.?\d*$/" onKeyPress="if(this.value.length==6) return false;" -->
                                                    @if ($errors->has('pincode_number'))
                                                    <div class="errors_msg text-danger">{{ $errors->first('pincode_number') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="phone_number">Mobile Number<span class="required">*</span></label>
                                                <div class="col-md-2">
                                                    <select class="select2-size-lg form-control large-select"  id="phonecode" name="phonecode">
                                                        <option value="">Select Phone Code</option>
                                                        @if(is_object($countryphonecode) && count($countryphonecode) > 0)
                                                            @foreach($countryphonecode as $countryphonecode_val)
                                                                <option value="{{$countryphonecode_val->id}}" @if(old('phonecode', isset($data) ? $data->phonecode_id : null) == $countryphonecode_val->id) selected @endif>{{$countryphonecode_val->phonecode}} ({{$countryphonecode_val->name}})</option>
                                                            @endforeach 
                                                        @endif    
                                                    </select>
                                                    @if ($errors->has('phonecode')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('phonecode') }}</div>
                                                    @endif
                                                </div>
                                                <div class="col-md-7">
                                                    <input type="number" id="phone_number" class="form-control" name="phone_number" value="{{{ old('phone_number', isset($data) ? $data->phone_number : null) }}}">
                                                    @if ($errors->has('phonecode')) 
                                                    @elseif ($errors->has('phone_number')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('phone_number') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="email_address">Email<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="email" id="email_address" class="form-control" name="email_address" value="{{{ old('email_address', isset($data) ? $data->email_address : null) }}}">
                                                    @if ($errors->has('email_address')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('email_address') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Image<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="file" id="logo_image" class="form-control" name="logo_image" value="">
                                                    @if ($errors->has('logo_image'))
                                                        <div class="errors_msg text-danger">{{ $errors->first('logo_image') }}</div>
                                                    @endif
                                                    <p>Allow type: jpeg, png, jpg.</p>
                                                    <?php 
                                                    $logo_image_url = isset($data) ? $data->logo_image_url : '';
                                                    ?>
                                                    @if($logo_image_url != '')
                                                        <img src="{{$logo_image_url  }}" width="100">
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="website">Website</label>
                                                <div class="col-md-9">
                                                    <input type="text" id="website" class="form-control" name="website" value="{{{ old('website', isset($data) ? $data->website : null) }}}">
                                                    @if ($errors->has('website')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('website') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Save & Exit">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Save">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">
function fun_frm_submit(){
    $('.loader_block').show();
}
$(document).ready(function() {
    $('#phonecode').select2({
        placeholder: "Select Phone Code", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
});
</script>
@endsection
