@extends('admin.layout.main')
@section('content')
<style>
    div#myTabContent {
    margin-top: 20px;
}
</style>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    View Employee User Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('employee.user.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body view-category-page">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="detail-tab" data-toggle="tab" data-target="#detail" type="button" role="tab" aria-controls="detail" aria-selected="true">Detail</button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="document-tab" data-toggle="tab" data-target="#document" type="button" role="tab" aria-controls="document" aria-selected="false">Document</button>
                                        </li>
                                    </ul>
                                    <div class="tab-content" id="myTabContent">
                                        <div class="tab-pane fade show active" id="detail" role="tabpanel" aria-labelledby="detail-tab">
                                            <form method="POST" enctype="multipart/form-data" action="@if(isset($data)){{ route('city.update',$data->id) }} @else{{ route('city.store') }}@endif">
                                            @csrf
                                            @if(isset($data))
                                                <input type="hidden" name="id" value="{{ $data->id }}" />
                                            @endif
                                            <div class="form-body">	      
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="designation">Designation</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('designation', is_object($data) ? $data->designation : null) }}</p>
                                                    </div>
                                                </div>              		
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="name">Name</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('name', isset($data) ? $data->name : null) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="email_address">Email</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('email_address', isset($data) ? $data->email_address : null) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="phone_number">Phone Number</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('phonecode', isset($data) ? $data->phonecode : null) }}
                                                        {{ old('phone_number', isset($data) ? $data->phone_number : null) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="address">Address</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('address', isset($data) ? $data->address : null) }}</p>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="website">Website</label>
                                                    <div class="col-md-9">
                                                        <p>{{ old('website', isset($data) ? $data->website : null) }}</p>
                                                    </div>
                                                </div>
                                                
                                            </div>    
                                        </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')

@endsection
