@extends('admin.layout.main')
@section("content")
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">Dashboard</h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body"><!-- Revenue, Hit Rate & Deals -->
            <div class="row">
                <?php 
                    $role_name = Auth::check() ? Auth::user()->role_name : '';
                ?>
                    <div class="col-lg-12 col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Uploaded Document </h4>
                            </div>
                            <div class="row">
                                <div class="col-md-12 card-content collapse show" style="background-color: #ffffff;">
                                    <div class="table-responsive">
                                        <div class="bd-example">
                                            <table class="table table-responsive-lg" id="document_uploaded_table" style="text-align: center;">
                                                <thead>
                                                    <tr>
                                                        <th scope="col">Customer
                                                            <select class="form-control" id="filter_customer_id" name="filter_customer_id[]">
                                                                <option value="">All</option>
                                                                @if(is_object($customer_user_list))
                                                                    @foreach ($customer_user_list as $value)
                                                                    <option value="{{$value->id}}">{{$value->name}}</option>
                                                                    @endforeach  
                                                                @endif 
                                                            </select>
                                                        </th>
                                                        <th scope="col">Uploaded Document</th>
                                                        <th scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')  
<script type="text/javascript">
    var table = $('#document_uploaded_table').DataTable({
        processing: true,
        serverSide: true,
        // scrollX : 500,
        // responsive : true,
        pageLength: '{{config("constants.PAR_PAGE_LENGHT")}}',
        //ajax: "{{ route('admin.dashboard.document_uploaded') }}",
        "ajax": {
            url: "{{ route('admin.dashboard.document_uploaded') }}",
            data: function (d) {
                d.filter_customer_id = jQuery("#filter_customer_id").val();
            },
        },
        columns: [       
        {
            data: 'customer_name',
            name: 'customer_name',
            className: 'text-left'
        },
        {
            data: 'total_count',
            name: 'total_count',
            className: 'text-center'
        },
        {
            data: 'action',
            name: 'action',
            orderable: false,
            searchable: false,
            className: 'text-left'
        },
        ]
    });
    $('#filter_reminder_id').on('change', function(e) {
        e.preventDefault();
        table.draw();
    });
    $('#filter_customer_id').on('change', function(e) {
        e.preventDefault();
        table.draw();
    });
    $('#filter_document_id').on('change', function(e) {
        e.preventDefault();
        table.draw();
    });
</script>      
<script type="text/javascript">
$(document).ready(function() {
    $('#filter_reminder_id').select2({
        placeholder: "All Reminder", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
    $('#filter_customer_id').select2({
        placeholder: "All Customer", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
    $('#filter_document_id').select2({
        placeholder: "All Document", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
});
</script>
<!-- BEGIN: Page Vendor JS  ' . route('admin.dashboard.document_reject', $row->id) . '-->
<!-- <script src="{{asset('app-assets/vendors/js/charts/chartist.min.js')}}" type="text/javascript"></script> -->
<!-- <script src="{{asset('app-assets/vendors/js/charts/chartist-plugin-tooltip.min.js')}}" type="text/javascript"></script> -->
<!-- <script src="{{asset('app-assets/js/scripts/pages/dashboard-analytics.min.js')}}" type="text/javascript"></script> -->
<!-- END: Page Vendor JS-->
@endsection