@extends('admin.layout.main')
@section('content')
<style>
    .ck-editor__editable_inline {
    max-height: 400px !important;
}
</style>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($data)) 
                        Edit 
                    @else 
                        Add 
                    @endif
                    Mass Email Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('mass_email.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($data)){{ route('mass_email.update',$data->id) }} @else{{ route('mass_email.store') }}@endif">
                                        @csrf
                                        @if(isset($data))
                                            <input type="hidden" name="id" value="{{ $data->id }}" />
                                        @endif
                                        <div class="form-body">	 
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="">From Email</label>
                                                <div class="col-md-9">
                                                    <?php 
                                                    echo $from_email = Auth::check() ? Auth::user()->email : '';
                                                    ?>
                                                </div>
                                            </div>  
                                            <?php
                                            $all_group_id_selected = array();
                                            if(old('group_id') != ''){
                                                $all_group_id_selected = old('group_id');
                                            }
                                            ?>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="group_id">Group<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select"  id="group_id" name="group_id[]" multiple>
                                                        @if(is_object($group))
                                                            @foreach ($group as $value)
                                                            <option value="{{$value->id}}"
                                                            @if(isset($all_group_id_selected))
                                                                @if(in_array($value->id,$all_group_id_selected))
                                                                    selected
                                                                @endif
                                                            @endif    
                                                            >{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('group_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('group_id') }}</div>
                                                    @endif
                                                </div>
                                            </div> 
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="customer_email">Customer<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select"  id="customer_email" name="customer_email[]" multiple>
                                                        @if(is_object($customer_list))
                                                            @foreach ($customer_list as $value)
                                                            <?php
                                                            $Groupname = '';
                                                            if (is_object($value->Group)) {
                                                                $Groupname = $value->Group->name;
                                                            }
                                                            ?>
                                                            <option value="{{$value->email_address}}"
                                                            @if(old('customer_email')!="")
                                                                @if (in_array($value->email_address, old('customer_email')))
                                                                    selected
                                                                @endif
                                                            @endif
                                                            >{{$value->name}} - {{$Groupname}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('customer_email')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('customer_email') }}</div>
                                                    @endif
                                                </div>
                                            </div>     
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="customer_to_email">Contact Person Email</label>
                                                <div class="col-md-9">
                                                    <select name="customer_to_email[]" id="customer_to_email" class="form-control" multiple="multiple">
                                                    @if(is_object($customer_contact_list))
                                                        @foreach ($customer_contact_list as $value)
                                                            <option value="{{$value->id}}" 
                                                            @if(old('customer_to_email') != '')
                                                                @if(in_array($value->id,old('customer_to_email')))
                                                                    selected
                                                                @endif
                                                            @elseif(isset($selected_customer_id_to))
                                                                @if(in_array($value->id,$selected_customer_id_to))
                                                                    selected
                                                                @endif
                                                            @endif
                                                            >{{$value->email}} - {{$value->customer_users_name}}</option>
                                                        @endforeach  
                                                    @endif 
                                                    </select>
                                                </div>
                                            </div>          		
                                            <div class="form-group row" style="display:none;">
                                                <label class="col-md-2 label-control" for="title">Title<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="title" class="form-control" name="title" value="<?php echo date('d-m-Y H:i:sA')?>">
                                                    @if ($errors->has('title')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('title') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="subject">Subject<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="subject" class="form-control" name="subject" value="{{{ old('subject', isset($data) ? $data->subject : null) }}}">
                                                    @if ($errors->has('subject')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('subject') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="content">Content<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <textarea id="content" class="form-control ckeditor" cols="5" name="content">{{{ old('content', isset($data) ? $data->content : null) }}}</textarea>
                                                    @if ($errors->has('content')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('content') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="attachment">Attachment</label>
                                                <div class="col-md-9">
                                                <input type="file" name="attachment[]" id="attachment" class="form-control" value="" multiple>
                                                </div>
                                            </div>
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Send">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<style>
    .btn-group{
        width:100%;
    }
    .multiselect-container.dropdown-menu {
        margin-top:0px !important;
        max-height: 380px !important;
        overflow-x: hidden !important;
        overflow-y: scroll !important;
        width:100%;
    }
    .caret {
       /* float: right;
        border-top: 7px dashed !important;
        border-top: 4px solid\9 !important;
        border-right: 7px solid transparent !important;
        border-left: 7px solid transparent !important;
        margin-top: 6px;*/
    }
    .multiselect.dropdown-toggle {
      text-align: left !important;
     /* width: 100%;*/
    }
    </style>
@endsection
@section('js')
<link rel="stylesheet" href="{{ asset('/app-assets/multiselect/css/bootstrap-multiselect.css') }}" type="text/css">
<script type="text/javascript" src="{{ asset('/app-assets/multiselect/js/bootstrap-multiselect.js') }}"></script>
<script type="text/javascript">
function fun_frm_submit(){
    $('.loader_block').show();
}
$(document).ready(function() {
    /*$('#customer_email').select2({
        placeholder: "Select Customer", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });*/
    $('#group_id').multiselect({
        enableFiltering: true,
        enableCaseInsensitiveFiltering: true,
        includeSelectAllOption: true,
        maxHeight: 400,
        dropUp: true
    });
    $('#customer_email').multiselect({
        enableFiltering: true,
        enableCaseInsensitiveFiltering: true,
        includeSelectAllOption: true,
        maxHeight: 400,
        dropUp: true
    });
    $('#customer_to_email').multiselect({
        enableFiltering: true,
        enableCaseInsensitiveFiltering: true,
        includeSelectAllOption: true,
        maxHeight: 400,
        dropUp: true
    });
    
    $('#group_id').change(function() {
        var Selected = $('#group_id').find("option:selected");
        var arrSelected = [];
        var arrgroupSelected = [];
        Selected.each(function(){
            arrgroupSelected.push($(this).val());
        });
        group_id = 'all'
        customer_search = '';//$('#customer_search').val();
        var selected = $('#customer_email').find("option:selected");
        var arrcustomer_emailSelected = [];
        selected.each(function(){
            arrcustomer_emailSelected.push($(this).val());
        });
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url : "{{ url('get_group_by_customer') }}/"+group_id,      
            data: {'group_id':group_id,'arrgroupSelected':arrgroupSelected,'arrcustomer_emailSelected':arrcustomer_emailSelected,'arrSelected':arrSelected,'customer_search':customer_search},  
            type : 'post',
            dataType : 'json',
            beforeSend : function(data){
                //$('.loader_block').show();
            }
        }).done(function(data) {
        // Code to execute if the request is successfulbeforeSend
            $('#customer_email').empty();
            $.each(data, function(key, customer_detail) {
                console.log(customer_detail.email_address);
                var selected = customer_detail.customer_to_email_selected;
                $('#customer_email').append('<option value="' + customer_detail.email_address + '" '+selected+ '>' + customer_detail.name + '</option>');
            });
            $("#customer_email").multiselect('rebuild');
            //$('.loader_block').hide();
        }).fail(function(jqXHR, textStatus, errorThrown) {
        // Code to execute if the request fails
            console.error("Request failed: " + textStatus);
        });
    });  
    $('#customer_email').change(function() {
        var selected = $('#customer_email').find("option:selected");
        var arrSelected = [];
        var arremailSelected = [];
        selected.each(function(){
            arremailSelected.push($(this).val());
        });
        var selected_customer_to_email = $('#customer_to_email').find("option:selected");
        var arrSelected_customer_to_email = [];
        selected_customer_to_email.each(function(){
            arrSelected_customer_to_email.push($(this).val());
        });
        customer_search = '';//$('#customer_search').val();
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url : "{{ url('get_customer_contact_details') }}",      
            data: {'arrSelected':arrSelected,'action_flage':'email_wise','arremailSelected':arremailSelected,'arrSelected_customer_to_email':arrSelected_customer_to_email,'customer_search':customer_search},  
            type : 'post',
            dataType : 'json',
            beforeSend : function(data){
                //$('.loader_block').show();
            }
        }).done(function(data) {
        // Code to execute if the request is successfulbeforeSend
            $('#customer_to_email').empty();
            $.each(data, function(key, customer_contact) {
                var selected = customer_contact.customer_to_email_selected;
                $('#customer_to_email').append('<option value="' + customer_contact.id + '" '+selected+ '>' + customer_contact.email + '</option>');
            });
            $("#customer_to_email").multiselect('rebuild');
            //$('.loader_block').hide();
        }).fail(function(jqXHR, textStatus, errorThrown) {
        // Code to execute if the request fails
            console.error("Request failed: " + textStatus);
        });
    });
});
</script>
<script src="https://cdn.ckeditor.com/ckeditor5/41.4.2/classic/ckeditor.js"></script>
<script>
ClassicEditor
    .create( document.querySelector( '#content' ) )
    .then( editor => {
             window.editor = editor;
            const imageBtn = document.querySelector('.ck-file-dialog-button');
            imageBtn.style.display = 'none';
    } )
    .catch( error => {
            console.error( error );
    } );
    
    ClassicEditor.replace( 'content',
     {
          toolbar : 'simple'
     })
</script>
@endsection
