@extends('admin.layout.main')
@section('content')
<style>
    .ck-editor__editable_inline {
    max-height: 400px !important;
}
.multiple_select{
    overflow-y: auto !important;
}
.highlight{ 
  background:#00FF00; 
  padding:1px; 
  border:#00CC00 dotted 1px; 
}
.highlight_lenght{ 
    background: #00FF00;
    padding: 5px 15px 5px 15px;
    font-weight: bold;
}
.list-group-item {
    font-weight: bold;
    padding: 12px;
}
.modal-backdrop {
    z-index: 1066;
}
.heading_wise_block {
    display: inline-block;
    width: 20%;
    vertical-align: top;
}
</style>
<style>
    .search-box-container-customer input {
        padding: 5px 20px 5px 5px;
        width: 100%;
    }
    .search-box-container-customer:after {
        content: "\f002";
        font-family: FontAwesome;
        margin-left: -25px;
        margin-right: 0px;
    }
    .search-box-container-document input {
        padding: 5px 20px 5px 5px;
        width: 100%;
    }
    .search-box-container-document:after {
        content: "\f002";
        font-family: FontAwesome;
        margin-left: -25px;
        margin-right: 0px;
        margin-top: 7px;
    }
</style>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($data)) 
                        Edit 
                    @else 
                        Add 
                    @endif
                    Quotation Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('quotation.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($data)){{ route('quotation.update',$data->id) }} @else{{ route('quotation.store') }}@endif">
                                        @csrf
                                        @if(isset($data))
                                            <input type="hidden" name="id" value="{{ $data->id }}" />
                                        @endif
                                        <?php 
                                        $from_email = Auth::check() ? Auth::user()->email : '';
                                        ?>
                                        <div class="form-body"> 
                                            <div class="form-group row" style="">
                                                <label class="col-md-2 label-control" for="company_id">Company<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select"  id="company_id" name="company_id">
                                                        <option value="">Select Company</option>
                                                        @if(is_object($company))
                                                            @foreach ($company as $value)
                                                                <option value="{{$value->id}}"
                                                                @if(old('company_id', isset($data) ? $data->company_id : null) == $value->id) selected @endif
                                                                >{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('company_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('company_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row" style="">
                                                <label class="col-md-2 label-control" for="customer_type">Customer Type<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                <input type="radio" name="customer_type" {{ $customer_type_automatic }} id="automatic" value="automatic"> <label for="automatic">Automatic</label>
                                                    &nbsp;&nbsp;&nbsp;<input type="radio" {{ $customer_type_manual }} name="customer_type" id="manual" value="manual"> <label for="manual">Manual</label>
                                                    @if ($errors->has('customer_type')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('customer_type') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <?php 
                                            $automatic_block = '';
                                            $manual_block = 'display:none;';
                                            if($customer_type_manual == 'checked'){
                                                $automatic_block = 'display:none;';
                                                $manual_block = '';                
                                            }
                                            ?>
                                            <span class="automatic_block"  style="{{$automatic_block  }}">
                                            <div class="form-group row ">
                                                <label class="col-md-2 label-control" for="customer_id">Customer<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                <?php
                                                $all_customer_id_selected = array();
                                                if(old('customer_id') != ''){
                                                    $all_customer_id_selected = old('customer_id');
                                                }elseif(isset($selected_customer_id)){
                                                    $all_customer_id_selected = $selected_customer_id;
                                                }
                                                ?>
                                                <select name="customer_id[]" id="customer_id" class="form-control"><!--   multiple="multiple" --> 
                                                    <option value="">Select Customer</option>
                                                    @if(is_object($customer_list))
                                                        @foreach ($customer_list as $value)
                                                            <?php
                                                            $Groupname = '';
                                                            if (is_object($value->Group)) {
                                                                $Groupname = $value->Group->name;
                                                            }
                                                            ?>
                                                            <option value="{{$value->id}}" 
                                                            @if(isset($all_customer_id_selected))
                                                                @if(in_array($value->id,$all_customer_id_selected))
                                                                    selected
                                                                @endif
                                                            @endif
                                                            >{{$value->name}} - {{$Groupname}}</option>
                                                        @endforeach  
                                                    @endif 
                                                </select>
                                                    @if ($errors->has('customer_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('customer_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="customer_to_email">To Email</label>
                                                <div class="col-md-9">
                                                    <select name="customer_to_email[]" id="customer_to_email" class="form-control" multiple="multiple">
                                                    @if(is_object($customer_contact_list))
                                                        @foreach ($customer_contact_list as $value)
                                                            <option value="{{$value->id}}" 
                                                            @if(old('customer_to_email') != '')
                                                                @if(in_array($value->id,old('customer_to_email')))
                                                                    selected
                                                                @endif
                                                            @elseif(isset($selected_customer_id_to))
                                                                @if(in_array($value->id,$selected_customer_id_to))
                                                                    selected
                                                                @endif
                                                            @endif
                                                            >{{$value->email}} - {{$value->customer_users_name}}</option>
                                                        @endforeach  
                                                    @endif 
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="customer_cc_email">CC Email</label>
                                                <div class="col-md-9">
                                                <select name="customer_cc_email[]" id="customer_cc_email" class="form-control" multiple="multiple">
                                                    @if(is_object($customer_contact_list))
                                                        @foreach ($customer_contact_list as $value)
                                                            <option value="{{$value->id}}" 
                                                            @if(old('customer_cc_email') != '')
                                                                @if(in_array($value->id,old('customer_cc_email')))
                                                                    selected
                                                                @endif
                                                            @elseif(isset($selected_customer_id_cc))
                                                                @if(in_array($value->id,$selected_customer_id_cc))
                                                                    selected
                                                                @endif
                                                            @endif
                                                            >{{$value->email}} - {{$value->customer_users_name}}</option>
                                                        @endforeach  
                                                    @endif 
                                                </select>
                                                </div>
                                            </div>
                                            </span>
                                            <span class="manual_block"  style="{{$manual_block  }}">
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="manual_customer_name">Customer<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="manual_customer_name" class="form-control" name="manual_customer_name" value="{{{ old('manual_customer_name', isset($data) ? $data->manual_customer_name : null) }}}">
                                                    @if ($errors->has('manual_customer_name')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('manual_customer_name') }}</div>
                                                    @endif        
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="manual_kind_attn">Kind Attn<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="manual_kind_attn" class="form-control" name="manual_kind_attn" value="{{{ old('manual_kind_attn', isset($data) ? $data->manual_kind_attn : null) }}}">
                                                    @if ($errors->has('manual_kind_attn')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('manual_kind_attn') }}</div>
                                                    @endif        
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="manual_customer_address">Address line 1</label>
                                                <div class="col-md-9">
                                                    <textarea id="manual_customer_address" class="form-control" name="manual_customer_address">{{{ old('manual_customer_address', isset($data) ? $data->manual_customer_address : null) }}}</textarea>
                                                    @if ($errors->has('manual_customer_address')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('manual_customer_address') }}</div>
                                                    @endif        
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="manual_customer_address_2">Address line 2</label>
                                                <div class="col-md-9">
                                                    <textarea id="manual_customer_address_2" class="form-control" name="manual_customer_address_2">{{{ old('manual_customer_address_2', isset($data) ? $data->manual_customer_address_2 : null) }}}</textarea>
                                                    @if ($errors->has('manual_customer_address_2')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('manual_customer_address_2') }}</div>
                                                    @endif        
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="manual_customer_address_3">Address line 3</label>
                                                <div class="col-md-9">
                                                    <textarea id="manual_customer_address_3" class="form-control" name="manual_customer_address_3">{{{ old('manual_customer_address_3', isset($data) ? $data->manual_customer_address_3 : null) }}}</textarea>
                                                    @if ($errors->has('manual_customer_address_3')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('manual_customer_address_3') }}</div>
                                                    @endif        
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="manual_customer_phone">Phone Number</label>
                                                <div class="col-md-9">
                                                    <input type="text" id="manual_customer_phone" class="form-control" name="manual_customer_phone" value="{{{ old('manual_customer_phone', isset($data) ? $data->manual_customer_phone : null) }}}">
                                                    @if ($errors->has('manual_customer_phone')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('manual_customer_phone') }}</div>
                                                    @endif        
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="manual_customer_to_email">To Email<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="manual_customer_to_email" class="form-control" name="manual_customer_to_email" value="{{{ old('manual_customer_to_email', isset($data) ? $data->manual_customer_to_email : null) }}}">
                                                    <p>Multiple Email Add comma Separator</p>
                                                    @if ($errors->has('manual_customer_to_email')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('manual_customer_to_email') }}</div>
                                                    @endif 
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="manual_customer_cc_email">CC Email</label>
                                                <div class="col-md-9">
                                                    <input type="text" id="manual_customer_cc_email" class="form-control" name="manual_customer_cc_email" value="{{{ old('manual_customer_cc_email', isset($data) ? $data->manual_customer_cc_email : null) }}}">
                                                    <p>Multiple Email Add comma Separator</p>
                                                    @if ($errors->has('manual_customer_cc_email')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('manual_customer_cc_email') }}</div>
                                                    @endif         
                                                </div>
                                            </div>
                                            </span>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="currency_id">Currency<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select"  id="currency_id" name="currency_id">
                                                        @if(is_object($currency))
                                                            @foreach ($currency as $value)
                                                                <option value="{{$value->id}}" data-symbol="{{$value->symbols}}"
                                                                @if(old('currency_id', isset($data) ? $data->currency_id : null) == $value->id) selected @endif
                                                                >{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('currency_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('currency_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="vat">VAT %<span class="required">*</span></label>
                                                <div class="col-md-2">
                                                    <input type="number" id="vat" min="0" class="form-control" name="vat" value="{{{ old('vat', isset($data) ? $data->vat : 0) }}}">
                                                    @if ($errors->has('vat')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('vat') }}</div>
                                                    @endif
                                                </div>
                                                <div class="col-md-1" style="padding-top: 10px;padding-left: 0px;font-size: 17px;font-weight: 700;">
                                                    %
                                                </div>
                                            </div>
                                            <div class="form-group row" style="">
                                                <label class="col-md-2 label-control" for="">Service<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <a href="javascript:;" onclick="fun_get_service();" class="btn btn-danger mr-1 btn-sm">View Service</a>
                                                    @if ($errors->has('service_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('service_id') }}</div>
                                                    @endif
@if(is_object($service_list))                                                
<div class="modal fade" style="z-index: 106811;" id="service_list_Modal" tabindex="-1" role="dialog" aria-labelledby="service_list_ModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="service_name_block">
                <strong>Service </strong>
                <!-- &nbsp;&nbsp;<input id="service_chk"  class="all_select_unselect" type="checkbox" class="check_uncheck_all"> <small><label for="assigment_chk_{{$value->id}}">All Select / UnSelect</label></small> -->
                </h5>    
                <div class="row col-md-6" style="align-items: center;">
                    <div class="col-md-5 search-box-container-document">
                        <input  type="text" class="on-page-search" id="searchtxt" />
                    </div>
                    <div class="col-md-7" id="searchcount"></div>
                </div>
            
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body row" id="service_list_val_block">
        <?php
        $department_wise_service = array();
        foreach ($service_list as $service_list_main){
            $department_wise_service[$service_list_main->department_id][] = $service_list_main;
        }
        ?>
          @foreach ($department_wise_service as $department_key=>$department_wise_service_val)
            <div class="col-sm-4"><!-- heading_wise_block -->
                <?php $heading_name = \App\Helper\Helpers::GetDepartmentName($department_key);?>
                <h3 style="font-weight: 700;">{{$heading_name}}</h3>
                @foreach ($department_wise_service_val as $service_list_val)
                    <div class="row">
                        <div class="col-sm-6">
                            <?php $style_doc_checked = 'display:none;';?>
                            <input type="checkbox" name="service_id[{{$service_list_val->id}}]" class="service_id" id="service_id_{{$service_list_val->id}}" value="{{$service_list_val->id}}"
                            @if(old('service_id') != '')
                                @if(!empty(old('service_id')))
                                @if(in_array($service_list_val->id,old('service_id')))
                                    <?php $style_doc_checked = 'display:inline-block';?>
                                    checked
                                @endif
                                @endif
                            @elseif(isset($selected_service_id))
                                @if(in_array($service_list_val->id,$selected_service_id))
                                    <?php $style_doc_checked = 'display:inline-block';?>
                                    checked
                                @endif
                            @endif
                            >
                            <label for="service_id_{{$service_list_val->id}}" style="display: inline;"><strong  class="inner-list-doc">{{$service_list_val->name}}</strong></label>
                            <?php 
                            $fill_data = '';
                            ?>
                            @if(old('service_description') != '')
                            <?php 
                            $fill_data = isset(old('service_description')[$service_list_val->id]) ? old('service_description')[$service_list_val->id] : '';
                            ?>
                            @elseif(count($selected_service_description) > 0)
                            <?php 
                                $fill_data = isset($selected_service_description[$service_list_val->id]) ? $selected_service_description[$service_list_val->id] : '';
                            ?>   
                            @endif
                            <textarea style="<?php echo $style_doc_checked;?>" name="service_description[{{$service_list_val->id}}]" class="form-control"  id="service_description_{{$service_list_val->id}}" placeholder="Description For {{$service_list_val->name}}">{{$fill_data}}</textarea>
                        </div>    
                        <div class="col-sm-2 currency_display" style="text-align: right;padding: 0px;margin-top: 30px;font-weight: 700;"></div>
                        <div class="col-sm-4" style="margin-top: 19px;">
                            <?php 
                            $fill_data = '';
                            ?>
                            @if(old('service_price') != '')
                            <?php 
                            $fill_data = isset(old('service_price')[$service_list_val->id]) ? old('service_price')[$service_list_val->id] : '';
                            ?>
                            @elseif(count($selected_service_price) > 0)
                            <?php 
                                $fill_data = isset($selected_service_price[$service_list_val->id]) ? $selected_service_price[$service_list_val->id] : '';
                            ?>   
                            @endif
                            <input type="number" min="0" name="service_price[{{$service_list_val->id}}]" class="form-control" value="{{$fill_data}}" placeholder="Price">
                        </div>
                    </div>
                    @endforeach    
            </div>
        @endforeach
        </div>
        <div class="modal-footer" style="justify-content: center;">
            <button type="button" class="btn btn-primary"  data-dismiss="modal">Ok</button>
        </div>
        </div>
    </div>
</div>
@endif
                                                </div>
                                            </div>
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Save & Exit">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Save">
                                                <!-- <input class="btn btn-primary submit btn-sm" name="save_send" type="submit" value="Save & Send"> -->
                                                <input class="btn btn-primary submit btn-sm" name="save_view" type="submit" value="Save & View">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<!-- <script src="https://www.jqueryscript.net/demo/Two-side-Multi-Select-Plugin-with-jQuery-multiselect-js/js/multiselect.js"></script> -->
<script type="text/javascript">
    $('input[type=radio][name=customer_type]').change(function() {
        if (this.value == 'manual') {
            $(".manual_block").css({"display": "block"});
            $(".automatic_block").css({"display": "none"});
            //$('.manual_block').css('display:block');
            //$('.automatic_block').css('display:none');
        }else{
            $(".automatic_block").css({"display": "block"});
            $(".manual_block").css({"display": "none"});
            //$('.automatic_block').css('display:block');
            //$('.manual_block').css('display:none');
            $('#customer_id').select2({
                placeholder: "Select Customer", // Optional: add a placeholder
                allowClear: true // Optional: allows the user to clear the selection
            });
            $('#customer_to_email').select2({
                placeholder: "Select To Email", // Optional: add a placeholder
                allowClear: true // Optional: allows the user to clear the selection
            });
            $('#customer_cc_email').select2({
                placeholder: "Select CC Email", // Optional: add a placeholder
                allowClear: true // Optional: allows the user to clear the selection
            });
        }
    });
    $(document).ready(function() {
        $('#customer_id').select2({
            placeholder: "Select Customer", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
        $('#customer_to_email').select2({
            placeholder: "Select To Email", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
        $('#customer_cc_email').select2({
            placeholder: "Select CC Email", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
        $('#company_id').select2({
            placeholder: "Select Company", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
        $('#currency_id').select2({
            placeholder: "Select currency", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
         
    });
    $('#customer_id').change(function() {
        var selected = $('#customer_id').find("option:selected");
        var arrSelected = [];
        selected.each(function(){
            arrSelected.push($(this).val());
        });
        var selected_customer_to_email = $('#customer_to_email').find("option:selected");
        var arrSelected_customer_to_email = [];
        selected_customer_to_email.each(function(){
            arrSelected_customer_to_email.push($(this).val());
        });
        var selected_customer_cc_email = $('#customer_cc_email').find("option:selected");
        var arrSelected_customer_cc_email = [];
        selected_customer_cc_email.each(function(){
            arrSelected_customer_cc_email.push($(this).val());
        });
        customer_search = '';//$('#customer_search').val();
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url : "{{ url('get_customer_contact_details') }}",      
            data: {'arrSelected':arrSelected,'arrSelected_customer_to_email':arrSelected_customer_to_email,'arrSelected_customer_cc_email':arrSelected_customer_cc_email,'customer_search':customer_search},  
            type : 'post',
            dataType : 'json',
            beforeSend : function(data){
                //$('.loader_block').show();
            }
        }).done(function(data) {
        // Code to execute if the request is successfulbeforeSend
            $('#customer_to_email').empty();
            $.each(data, function(key, customer_contact) {
                var selected = customer_contact.customer_to_email_selected;
                $('#customer_to_email').append('<option value="' + customer_contact.id + '" '+selected+ '>' + customer_contact.email + '</option>');
            });
            $('#customer_cc_email').empty();
            $.each(data, function(key, customer_contact) {
                var selected = customer_contact.customer_cc_email_selected;
                $('#customer_cc_email').append('<option value="' + customer_contact.id + '" '+selected+ '>' + customer_contact.email + '</option>');
            });
            //$('.loader_block').hide();
        }).fail(function(jqXHR, textStatus, errorThrown) {
        // Code to execute if the request fails
            console.error("Request failed: " + textStatus);
        });
    });   
</script>
<script type="text/javascript">
    function fun_frm_submit(){
        $('.loader_block').show();
    }
    function fun_get_service(){
        $('#service_list_Modal').modal('show');
        currency_display = $('#currency_id').find(':selected').attr('data-symbol');
        $('.currency_display').html(currency_display);
    }
</script>
<script type="text/javascript">
    $('.service_id').change(function(){
        service_id_val = $(this).val();
        if($(this).prop('checked') == true){
            $('#service_description_'+service_id_val).show();
        }else{
            $('#service_description_'+service_id_val).hide();
        }
    }) 
    $('.all_select_unselect').change(function(){
        if($(this).prop('checked') == true){
            $('.service_id').attr('checked',true);
        }else{
            $('.service_id').attr('checked',false);
        }
    })    
    $(".on-page-search").on("keyup", function() {
        var filter_id = $(this).attr('data-filter_id');
        $('#searchcount').html('');
        var searchtxt = $('#searchtxt').val();
        $(".highlight").removeClass("highlight");
        $(".noresults").removeClass("noresults");
        $(".inner-list-doc").each(function() {
            if (searchtxt != "" && $(this).text().search(new RegExp(searchtxt, 'gi')) != -1) {
                $(this).addClass("highlight");
            } else if (searchtxt != "" && $(this).text().search(searchtxt) != 1) {
                $(this).addClass("noresults");
            }
        });
        if(searchtxt != ''){
            var numItems = $(".inner-list-doc.highlight").length;
            $('#searchcount').html('<span class="highlight_lenght">'+numItems+' Results Found</span>');
        }    
    });
</script>
@endsection
