@extends('admin.layout.main')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    View Quotation Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('quotation.edit',$data->id) }}"><button type="button" class="btn btn-secondary back_btn btn-sm"><i class="fa fa-edit" aria-hidden="true"></i> Edit</button></a>
                                <a href="{{ route('quotation.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                                <a href="{{ route('quotation.send',array('quotation_id'=>$data->id,'customer_id'=>$customer_id)) }}" class="btn badge-primary text-white btn-sm"><i class="fa fa-envelope"></i> Send</a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body view-category-page">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" enctype="multipart/form-data" action="@if(isset($data)){{ route('city.update',$data->id) }} @else{{ route('city.store') }}@endif">
                                        @csrf
                                        @if(isset($data))
                                            <input type="hidden" name="id" value="{{ $data->id }}" />
                                        @endif
                                        <div class="form-body">	
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">From Email</label>
                                                <div class="col-md-9">
                                                    <p>{{ isset($data) ? $data->from_email : null }}</p>
                                                </div>
                                            </div>                    		
                                            <div class="form-group row" style="">
                                                <label class="col-md-2 label-control" for="customer_type">Customer Type</label>
                                                <div class="col-md-9">
                                                    {{ucfirst($data->customer_type)}}
                                                </div>
                                            </div>
                                            <div class="form-group row ">
                                                <label class="col-md-2 label-control" for="customer_id">Customer</label>
                                                <div class="col-md-9">
                                                    {!! $selected_customer !!}
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="customer_to_email">To Email</label>
                                                <div class="col-md-9">
                                                    {!!$selected_customer_id_to!!}
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="customer_cc_email">CC Email</label>
                                                <div class="col-md-9">
                                                    {!!$selected_customer_id_cc!!}
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="">Quotation Pdf</label>
                                                <div class="col-md-9">
                                                @if(isset($data))
                                                    @if($data->pdf_file_name != '')
                                                        <?php 
                                                        $pdf_file_name = $destinationPath.$data->pdf_file_name;
                                                        ?>
                                                        @if(file_exists($pdf_file_name))
                                                            <iframe src="{{url('/') .'/quotation_pdf/'.$data->pdf_file_name}}" frameborder="0" allowfullscreen style="width: 100%;    height: 800px;"></iframe>
                                                        @endif
                                                    @endif
                                                @endif
                                                </div>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
@endsection
