    @extends('admin.layout.main')
    @section("content")
    <style>
    .table th:last-child, .table td:last-child {
        text-align: left;
    }    
    </style>
    <div class="app-content content">
        <div class="content-wrapper">
            <div class="content-wrapper-before"></div>
            <div class="content-header row">
                <div class="content-header-left col-md-8 col-12 mb-2">
                    <h3 class="content-header-title">Uploaded Document</h3>
                </div>
                <div class="content-header-right col-md-4 col-12">
                    <div class="breadcrumbs-top float-md-right">
                        <div class="breadcrumb-wrapper mr-1">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('reminder.document.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-refresh" aria-hidden="true"></i> Refresh</button></a>
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            <div class="content-body"><!-- Revenue, Hit Rate & Deals -->
                <div class="row">
                    <?php 
                        $role_name = Auth::check() ? Auth::user()->role_name : '';
                    ?>
                    <?php //if($role_name == 'Admin'){?>
                        <div class="col-lg-12 col-md-12">
                            <div class="card">
                                <div class="row">
                                    <div class="col-md-12 card-content collapse show" style="background-color: #ffffff;">
                                        <div class="table-responsive">
                                            <div class="bd-example">
                                                <table class="table table-responsive-lg" id="document_uploaded_table" style="text-align: center;">
                                                    <thead>
                                                    <tr>
                                                            <th scope="col">
                                                                <select class="form-control" id="filter_reminder_id" name="filter_reminder_id[]" style="width: 250px;">
                                                                    <option value="">All</option>
                                                                    @if(is_object($reminder_list))
                                                                        @foreach ($reminder_list as $value)
                                                                        <?php $selected = ''; ?>
                                                                        @if($search_reminder_id == $value->id)
                                                                            <?php $selected = 'selected'; ?>
                                                                        @endif
                                                                        <option value="{{$value->id}}" {{$selected}}>{{$value->name}}</option>
                                                                        @endforeach  
                                                                    @endif 
                                                                </select>
                                                            </th>
                                                            <th scope="col">
                                                                <select class="form-control" id="filter_customer_id" name="filter_customer_id[]" style="width: 250px;">
                                                                    <option value="">All</option>
                                                                    @if(is_object($customer_user_list))
                                                                        @foreach ($customer_user_list as $value)
                                                                        <?php $selected = ''; ?>
                                                                        @if($search_customer_id == $value->id)
                                                                            <?php $selected = 'selected'; ?>
                                                                        @endif
                                                                        <option value="{{$value->id}}" {{$selected}}>{{$value->name}}</option>
                                                                        @endforeach  
                                                                    @endif 
                                                                </select>
                                                            </th>
                                                            <th scope="col">
                                                                <select class="form-control" id="filter_document_id" name="filter_document_id[]" style="width: 250px;">
                                                                    <option value="">All</option>
                                                                    @if(is_object($document_list))
                                                                        @foreach ($document_list as $value)
                                                                        <?php $selected = ''; ?>
                                                                        @if($search_document_id == $value->id)
                                                                            <?php $selected = 'selected'; ?>
                                                                        @endif
                                                                        <option value="{{$value->id}}" {{$selected}}>{{$value->name}}</option>
                                                                        @endforeach  
                                                                    @endif 
                                                                </select>
                                                            </th>
                                                            <th scope="col"></th>
                                                            <th scope="col"></th>
                                                            <th scope="col">
                                                                <select class="form-control" id="filter_status" name="filter_status[]" style="width: 250px;">
                                                                    <option value="">All</option>
                                                                    <?php $selected_0 = '';$selected_1 = ''; $selected_2 = '';?>
                                                                    @if($search_status == 0)
                                                                        <?php $selected_0 = 'selected'; ?>
                                                                    @elseif($search_status == 1)
                                                                        <?php $selected_1 = 'selected'; ?>
                                                                    @elseif($search_status == 2)
                                                                        <?php $selected_2 = 'selected'; ?>        
                                                                    @endif
                                                                    <option value="0" {{$selected_0}}>Pending</option>
                                                                    <option value="1" {{$selected_1}}>Accepted</option>
                                                                    <!-- <option value="2" {{$selected_2}}>Rejected</option> -->
                                                                </select>
                                                            </th>
                                                        </tr>
                                                        <tr>
                                                            <th scope="col">Reminder</th>
                                                            <th scope="col">Customer</th>
                                                            <th scope="col">Document Name</th>
                                                            <th scope="col">Document</th>
                                                            <th scope="col">Date Time</th>
                                                            <th scope="col">Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php //} ?>    
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="DocumentRejectNoteModal" data-backdrop="false" data-keyboard="false" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <form id="DocumentRejectNoteForm"> 
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Document Reject Note</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <input type="hidden" id="document_reject_id" name="document_reject_id" value="0">
                        <label>Notes : <span class="text-danger">*</span></label>
                        <textarea class="form-control" name="notes" id="reject_notes" cols="12" rows="5" ></textarea>
                        <p id="error-message-notes" style="color: red; display: none;text-align: start;margin-top: 4px;">Please enter notes.</p>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-danger btn-sm">Submit</button>
            </div>
            </form>
        </div>
    </div>
    </div>
    @endsection
    @section('js')  
    <script type="text/javascript">
    //$(function() {
        var table = $('#document_uploaded_table').DataTable({
            processing: true,
            serverSide: true,
            // scrollX : 500,
            // responsive : true,
            pageLength: '{{config("constants.PAR_PAGE_LENGHT")}}',
            //ajax: "{{ route('reminder.document.index') }}",
            "ajax": {
                url: "{{ route('reminder.document.index') }}",
                data: function (d) {
                    d.filter_reminder_id = jQuery("#filter_reminder_id").val();
                    d.filter_customer_id = jQuery("#filter_customer_id").val();
                    d.filter_document_id = jQuery("#filter_document_id").val();
                    d.filter_status = jQuery("#filter_status").val();
                },
            },
            columns: [       
            {
                data: 'reminder_name',
                name: 'reminder_name',
                className: 'text-left'
            }, 
            {
                data: 'customer_name',
                name: 'customer_name',
                className: 'text-left'
            },
            {
                data: 'document_name',
                name: 'document_name',
                className: 'text-left'
            },
            {
                data: 'document_file',
                name: 'document_file',
                orderable: false,
                searchable: false,
                className: 'text-left'
            },
            {
                data: 'datetime',
                name: 'datetime',
                className: 'text-left'
            },
            {
                data: 'action',
                name: 'action',
                className: 'text-left'
            },
            ]
        });
        $('#filter_reminder_id').on('change', function(e) {
            e.preventDefault();
            table.draw();
        });
        $('#filter_customer_id').on('change', function(e) {
            e.preventDefault();
            table.draw();
        });
        $('#filter_document_id').on('change', function(e) {
            e.preventDefault();
            table.draw();
        });
        $('#filter_status').on('change', function(e) {
            e.preventDefault();
            table.draw();
        });
    //});
    </script>      
    <script type="text/javascript">
    $(document).ready(function() {
        $('#filter_reminder_id').select2({
            placeholder: "All Reminder", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
        $('#filter_customer_id').select2({
            placeholder: "All Customer", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
        $('#filter_document_id').select2({
            placeholder: "All Document", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
        $('#filter_status').select2({
            placeholder: "All Status", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
    });
    </script>
    <script>
    function confirm_document_reject(id) {
        if (confirm("Are you sure you want to Reject this?")) {
            $('#document_reject_id').val(id);
            $('#reject_notes').val('');
            $('#reject_notes').attr('rows', '5');
            $('#reject_notes').attr('cols', '13');
            $('#reject_notes').attr('style', 'height:110px;');
            $('#error-message-notes').hide();
            $('#DocumentRejectNoteModal').modal('show');
            return false;
        }    
    }
    $(document).ready(function() {
        $('#DocumentRejectNoteForm').on('submit', function(e) {
            e.preventDefault(); // Prevent the form from submitting normally
            SubmitNotes(); // Call the custom function to handle form submission
        });
        function SubmitNotes(){
            var notes = $('#reject_notes').val();
            var error = 0
            if (notes == "" || notes == undefined) {
                $("#error-message-notes").show(); // Show error message
                $("#error-message-notes").text('Please enter notes.');
                return false;
                var error = 1
            } else {
                var error = 0
                $("#error-message-notes").hide(); // Hide error message
            }
            if(error == 0){
                $('.loader_block').show();
                document_reject_id = $('#document_reject_id').val();
                const formData = {};
                formData._token = "{{ csrf_token() }}";
                formData.document_reject_id = document_reject_id;
                formData.reject_notes = notes;
                $.ajax({
                    url: "{{ route('admin.dashboard.document_reject',1) }}",
                    method: "POST",
                    data: formData,
                    type: "JSON",
                    success: async function(result) {
                        if (result.status) {
                            $('.loader_block').hide();
                            $('#DocumentRejectNoteModal').modal('hide');
                            $.toast({
                                heading: 'Success',
                                text: result.message,
                                showHideTransition: 'slide',
                                icon: 'success',
                                position: 'mid-center',
                                stack: false
                            });
                            table.ajax.reload();
                        } else {
                            location.reload();
                        }
                    },
                    error: function(xhr) {
                    location.reload();
                    }
                });
            }
            return false;
        }
    });
    </script>
    <!-- BEGIN: Page Vendor JS-->
    <!-- <script src="{{asset('app-assets/vendors/js/charts/chartist.min.js')}}" type="text/javascript"></script> -->
    <!-- <script src="{{asset('app-assets/vendors/js/charts/chartist-plugin-tooltip.min.js')}}" type="text/javascript"></script> -->
    <!-- <script src="{{asset('app-assets/js/scripts/pages/dashboard-analytics.min.js')}}" type="text/javascript"></script> -->
    <!-- END: Page Vendor JS-->
    @endsection