@extends('admin.layout.main')
@section('content')
<style>
    .ck-editor__editable_inline {
    max-height: 400px !important;
}
.multiple_select{
    overflow-y: auto !important;
}
</style>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($data)) 
                        Edit 
                    @else 
                        Add 
                    @endif
                    Reminder Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('reminder.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($data)){{ route('reminder.update',$data->id) }} @else{{ route('reminder.store') }}@endif">
                                        @csrf
                                        @if(isset($data))
                                            <input type="hidden" name="id" value="{{ $data->id }}" />
                                        @endif
                                        <?php 
                                        $from_email = Auth::check() ? Auth::user()->email : '';
                                        ?>
                                        <div class="form-body">	
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="from_email">From Email<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="from_email" class="form-control" name="from_email" value="{{{ old('from_email', isset($data) ? $data->from_email : $from_email) }}}">
                                                    @if ($errors->has('from_email')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('from_email') }}</div>
                                                    @endif
                                                </div>
                                            </div>                     		
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Name<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="name" class="form-control" name="name" value="{{{ old('name', isset($data) ? $data->name : null) }}}">
                                                    @if ($errors->has('name')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('name') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="description">Description</label>
                                                <div class="col-md-9">
                                                    <textarea id="description" class="form-control" cols="5" name="description">{{{ old('description', isset($data) ? $data->description : null) }}}</textarea>
                                                    @if ($errors->has('description')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('description') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="role_name">Reminder Period<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <?php 
                                                    $Reminder_Period_array = config('constants.Reminder_Period');
                                                    ?>
                                                    <select class="select2-size-lg form-control large-select"  id="reminder_period" name="reminder_period">
                                                        @if($Reminder_Period_array)
                                                            @foreach ($Reminder_Period_array as $value_key=>$value_data)
                                                            <option value="{{$value_key}}"
                                                            @if(old('reminder_period', isset($data) ? $data->reminder_period : null) == $value_key) selected @endif>{{$value_data}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('reminder_period')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('reminder_period') }}</div>
                                                    @endif
                                                </div>
                                            </div> 
                                            <div class="form-group row">
                                                <label class="col-lg-2 col-md-4 label-control" for="document_id">Document<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select" id="document_id" name="document_id[]" multiple>
                                                         
                                                    </select>
                                                    @if ($errors->has('document_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('document_id') }}</div>
                                                    @endif 
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="group_id">Group</label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select"  id="group_id" name="group_id">
                                                        <option value="all">All Group</option>
                                                        @if(is_object($group))
                                                            @foreach ($group as $value)
                                                            <option value="{{$value->id}}"
                                                            >{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    <?php /*
@if(old('group_id', isset($data) ? $data->group_id : null) == $value->id) selected @elseif($value->name == 'India') selected @endif
                                                    */
                                                    ?>
                                                    @if ($errors->has('group_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('group_id') }}</div>
                                                    @endif
                                                </div>
                                            </div> 
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="description">Customer <span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <div class="row">
                                                        <div class="col-md-5">
                                                            <select name="from_customer_id[]" id="undo_redo" class="form-control multiple_select" size="20" multiple="multiple">
                                                                
                                                            </select>
                                                        </div>
                                                        <div class="col-md-2">
                                                            <button type="button" id="undo_redo_undo" class="btn btn-primary btn-min-width mr-1 mb-1">Undo</button>
                                                            <button type="button" id="undo_redo_rightAll" class="btn btn-outline-secondary btn-min-width mr-1 mb-1">>></button>
                                                            <button type="button" id="undo_redo_rightSelected" class="btn btn-outline-secondary btn-min-width mr-1 mb-1">></button>
                                                            <button type="button" id="undo_redo_leftSelected" class="btn btn-outline-secondary btn-min-width mr-1 mb-1"><</button>
                                                            <button type="button" id="undo_redo_leftAll" class="btn btn-outline-secondary btn-min-width mr-1 mb-1"><<</i></button>
                                                            <button type="button" id="undo_redo_redo" class="btn btn-warning btn-min-width mr-1 mb-1">Redo</button>
                                                        </div>
                                                        
                                                        <div class="col-md-5">
                                                            <?php
                                                            // echo '<pre>';
                                                            // print_r(old('customer_id'));
                                                            // echo '</pre>';
                                                            ?>
                                                            <select name="customer_id[]" id="undo_redo_to" class="form-control multiple_select" size="20" multiple="multiple">
                                                                @if(is_object($customer_list))
                                                                    @foreach ($customer_list as $value)
                                                                        <?php
                                                                        $Groupname = '';
                                                                        if (is_object($value->Group)) {
                                                                            $Groupname = $value->Group->name;
                                                                        }
                                                                        ?>
                                                                        @if(old('customer_id') != '')
                                                                            @if(in_array($value->id,old('customer_id')))
                                                                                <option value="{{$value->id}}" selected>{{$value->name}} - {{$Groupname}}</option>
                                                                            @endif
                                                                        @elseif(isset($selected_customer_id))
                                                                            @if(in_array($value->id,$selected_customer_id))
                                                                                <option value="{{$value->id}}" selected>{{$value->name}} - {{$Groupname}}</option>
                                                                            @endif
                                                                        @endif
                                                                    @endforeach  
                                                                @endif 
                                                            </select>
                                                        </div>
                                                    </div>
                                                    @if ($errors->has('customer_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('customer_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="attachment">Attachment</label>
                                                <div class="col-md-9">
                                                <input type="file" name="attachment[]" id="attachment" class="form-control" value="" multiple>
                                                </div>
                                            </div>
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Save & Exit">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Save">
                                                <input class="btn btn-primary submit btn-sm" name="save_send" type="submit" value="Save & Send">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="https://www.jqueryscript.net/demo/Two-side-Multi-Select-Plugin-with-jQuery-multiselect-js/js/multiselect.js"></script>
<script type="text/javascript">
    function fun_frm_submit(){
        var arrSelected = [];
        $("select#undo_redo_to option").each(function(){
            $(this).attr("selected","selected");
            $(this).prop("selected", true); 
            arrSelected.push($(this).val());
        });
        //$('#undo_redo').multiselect( 'reload' );
        console.log(arrSelected);
        //return false;
    }
    $('#group_id').change(function() {
        group_id = $(this).val();
        get_group_by_customer(group_id)
    });
    function get_group_by_customer(group_id){
        var selected = $('#undo_redo_to').find("option");
        var arrSelected = [];
        selected.each(function(){
            arrSelected.push($(this).val());
        });
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url : "{{ url('get_group_by_customer') }}" +'/'+ group_id,      
            data: {'arrSelected':arrSelected},  
            type : 'post',
            dataType : 'json',
            beforeSend : function(data){
                //$('.loader_block').show();
            }
        }).done(function(data) {
        // Code to execute if the request is successfulbeforeSend
            $('#undo_redo').empty();
            $.each(data, function(key, customer) {
                var selected = '';
                $('#undo_redo').append('<option value="' + customer.id + '" '+selected+ '>' + customer.name + '</option>');
            });
            //$('.loader_block').hide();
            
        }).fail(function(jqXHR, textStatus, errorThrown) {
        // Code to execute if the request fails
            console.error("Request failed: " + textStatus);
        });
    }
    get_group_by_customer('all');
	$(document).ready(function() {
		// $('#undo_redo').multiselect({
        //     search: {
        //         left: '<input type="text" name="q" class="form-control" placeholder="Search..." />'
        //     },
        // });
        $('#undo_redo').multiselect({
            enableFiltering: false,
            enableClickableOptGroups: true,
            includeSelectAllOption: true,
        });
        $('#document_id_undo_redo').multiselect({
            enableFiltering: false,
            enableClickableOptGroups: true,
            includeSelectAllOption: true,
        });
        
	});
</script>
<script type="text/javascript">
$(document).ready(function() {
    // $('#customer_id').select2({
    //     placeholder: "Select Customer", // Optional: add a placeholder
    //     allowClear: true // Optional: allows the user to clear the selection
    // });
    $('#document_id').select2({
        placeholder: "Select Document", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
});
</script>
@endsection
