@extends('admin.layout.main')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    View Reminder Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('reminder.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body view-category-page">
        <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="">
                                        @csrf
                                        @if(isset($data))
                                            <input type="hidden" name="id" value="{{ $data->id }}" />
                                        @endif
                                        <?php 
                                        $from_email = Auth::check() ? Auth::user()->email : '';
                                        ?>
                                        <div class="form-body"> 
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">From Email</label>
                                                <div class="col-md-9">
                                                    {{ isset($data) ? $data->from_email : null }} 
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="customer_id">Customer</label>
                                                <div class="col-md-9">
                                                <?php
                                                $all_customer_id_selected = array();
                                                if(isset($selected_customer_id)){
                                                    $all_customer_id_selected = $selected_customer_id;
                                                }
                                                ?>
                                                    @if(is_object($customer_list))
                                                        @foreach ($customer_list as $value)
                                                            <?php
                                                            $Groupname = '';
                                                            if (is_object($value->Group)) {
                                                                $Groupname = $value->Group->name;
                                                            }
                                                            ?>
                                                            @if(isset($all_customer_id_selected))
                                                                @if(in_array($value->id,$all_customer_id_selected))
                                                                    {{$value->name}} - {{$value->email_address}} [{{$Groupname}}]
                                                                @endif
                                                            @endif
                                                        @endforeach  
                                                    @endif 
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="customer_to_email">To Email</label>
                                                <div class="col-md-9">
                                                    @if(is_object($customer_contact_list))
                                                        @foreach ($customer_contact_list as $value)
                                                            @if(isset($selected_customer_id_to))
                                                                @if(in_array($value->id,$selected_customer_id_to))
                                                                <div>{{$value->email}} - {{$value->customer_users_name}}</div>
                                                                @endif
                                                            @endif
                                                        @endforeach  
                                                    @endif 
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="customer_cc_email">CC Email</label>
                                                <div class="col-md-9">
                                                    @if(is_object($customer_contact_list))
                                                        @foreach ($customer_contact_list as $value)
                                                            @if(isset($selected_customer_id_cc))
                                                                @if(in_array($value->id,$selected_customer_id_cc))
                                                                    <div>{{$value->email}} - {{$value->customer_users_name}}</div>
                                                                @endif
                                                            @endif
                                                        @endforeach  
                                                    @endif 
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Subject</label>
                                                <div class="col-md-9">
                                                    {{isset($data) ? $data->name : null }}
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="">Send Date</label>
                                                <div class="col-md-9">
                                                    <?php 
                                                    $send_date = '-';
                                                    if ($data->status == 1) {
                                                        $send_date = date('d-m-Y',strtotime($data->send_date));
                                                    }
                                                    echo $send_date;
                                                    ?>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="">Next Send Date</label>
                                                <div class="col-md-9">
                                                <?php 
                                                    $next_send_date = '-';
                                                    if ($data->status == 1) {
                                                        $next_send_date = date('d-m-Y',strtotime($data->next_send_date));
                                                    }
                                                    echo $next_send_date;
                                                    ?>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="role_name">Reminder Period</label>
                                                <div class="col-md-9">
                                                    <?php 
                                                    $Reminder_Period_array = config('constants.Reminder_Period');
                                                    ?>
                                                    @if($Reminder_Period_array)
                                                        @foreach ($Reminder_Period_array as $value_key=>$value_data)
                                                        @if((isset($data) ? $data->reminder_period : null) == $value_key)
                                                            {{$value_data}} 
                                                        @endif      
                                                        @endforeach  
                                                    @endif  
                                                </div>
                                            </div> 
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="assignment_id">Assignment</label>
                                                <div class="col-md-7">
                                                        @if(is_object($assignment))
                                                            @foreach ($assignment as $value)
                                                            @if(!$value->documents->isEmpty())
                                                                @if((isset($data) ? $data->assignment_id : null) == $value->id) 
                                                                    {{$value->name}} 
                                                                @endif
                                                            @endif    
                                                            @endforeach  
                                                        @endif  
                                                        <hr>
                                                        @if(is_object($document_list))
                                                            @foreach ($document_list as $value)
                                                                <div>{{$value->name}}</div>
                                                            @endforeach  
                                                        @endif
                                                        <hr>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="current_date_value">Current Date</label>
                                                <div class="col-md-9">
                                                    {{ (isset($data) ? $data->current_date_value : null) }}
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="year_end">Year End Date</label>
                                                <div class="col-md-9">
                                                    {{ (isset($data) ? $data->year_end : null) }}
                                                </div>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
@endsection
