@extends('admin.layout.main')
@section('content')
<style>
    .ck-editor__editable_inline {
    max-height: 400px !important;
}
.dropup {
    width: 100%;
    text-align: left;
}
.highlight{ 
  background:#00FF00; 
  padding:1px; 
  border:#00CC00 dotted 1px; 
}
.highlight_lenght{ 
    background: #00FF00;
    padding: 5px 15px 5px 15px;
    font-weight: bold;
}
.list-group-item {
    font-weight: bold;
    padding: 12px;
}
.modal-backdrop {
    z-index: 1066;
}
</style>
<style>
    .search-box-container-customer input {
        padding: 5px 20px 5px 5px;
        width: 100%;
    }
    .search-box-container-customer:after {
        content: "\f002";
        font-family: FontAwesome;
        margin-left: -25px;
        margin-right: 0px;
    }
    .search-box-container-document input {
        padding: 5px 20px 5px 5px;
        width: 100%;
    }
    .search-box-container-document:after {
        content: "\f002";
        font-family: FontAwesome;
        margin-left: -25px;
        margin-right: 0px;
        margin-top: 7px;
    }
</style>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($data)) 
                        Edit 
                    @else 
                        Add 
                    @endif
                    Schedule Mail Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('scheduler_reminder.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($data)){{ route('scheduler_reminder.update',$data->id) }} @else{{ route('scheduler_reminder.store') }}@endif">
                                        @csrf
                                        @if(isset($data))
                                            <input type="hidden" name="id" value="{{ $data->id }}" />
                                        @endif
                                        <?php 
                                        $from_email = Auth::check() ? Auth::user()->email : '';
                                        ?>
                                        <?php
                                        $all_group_id_selected = array();
                                        if(old('group_id') != ''){
                                            $all_group_id_selected = old('group_id');
                                        }elseif(isset($data)){
                                            if($data->group_id != NULL){
                                                $all_group_id_selected = json_decode($data->group_id,true);
                                            }    
                                        }
                                        ?>
                                        <div class="form-group row">
                                            <label class="col-md-2 label-control" for="group_id">Group<span class="required">*</span></label>
                                            <div class="col-md-9">
                                                <select class="select2-size-lg form-control large-select"  id="group_id" name="group_id[]" multiple>
                                                    @if(is_object($group))
                                                        @foreach ($group as $value)
                                                        <option value="{{$value->id}}"
                                                        @if(isset($all_group_id_selected))
                                                            @if(in_array($value->id,$all_group_id_selected))
                                                                selected
                                                            @endif
                                                        @endif
                                                        >{{$value->name}}</option>
                                                        @endforeach  
                                                    @endif  
                                                </select>
                                                @if ($errors->has('group_id')) 
                                                    <div class="errors_msg text-danger">{{ $errors->first('group_id') }}</div>
                                                @endif
                                            </div>
                                        </div> 
                                        <div class="form-body"> 
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="customer_id">Customer<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                <?php
                                                $all_customer_id_selected = array();
                                                if(old('customer_id') != ''){
                                                    $all_customer_id_selected = old('customer_id');
                                                }elseif(isset($selected_customer_id)){
                                                    $all_customer_id_selected = $selected_customer_id;
                                                }
                                                ?>
                                                <select name="customer_id[]" id="customer_id" class="form-control" multiple="multiple">
                                                    @if(is_object($customer_list))
                                                        @foreach ($customer_list as $value)
                                                            <?php
                                                            $Groupname = '';
                                                            if (is_object($value->Group)) {
                                                                $Groupname = $value->Group->name;
                                                            }
                                                            ?>
                                                            <option value="{{$value->id}}" 
                                                            @if(isset($all_customer_id_selected))
                                                                @if(in_array($value->id,$all_customer_id_selected))
                                                                    selected
                                                                @endif
                                                            @endif
                                                            >{{$value->name}} - {{$Groupname}}</option>
                                                        @endforeach  
                                                    @endif 
                                                </select>
                                                    @if ($errors->has('customer_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('customer_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="customer_to_email">To Email</label>
                                                <div class="col-md-9">
                                                    <select name="customer_to_email[]" id="customer_to_email" class="form-control" multiple="multiple">
                                                    @if(is_object($customer_contact_list))
                                                        @foreach ($customer_contact_list as $value)
                                                            <option value="{{$value->id}}" 
                                                            @if(old('customer_to_email') != '')
                                                                @if(in_array($value->id,old('customer_to_email')))
                                                                    selected
                                                                @endif
                                                            @elseif(isset($selected_customer_id_to))
                                                                @if(in_array($value->id,$selected_customer_id_to))
                                                                    selected
                                                                @endif
                                                            @endif
                                                            >{{$value->email}} - {{$value->customer_users_name}}</option>
                                                        @endforeach  
                                                    @endif 
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="customer_cc_email">CC Email</label>
                                                <div class="col-md-9">
                                                <select name="customer_cc_email[]" id="customer_cc_email" class="form-control" multiple="multiple">
                                                    @if(is_object($customer_contact_list))
                                                        @foreach ($customer_contact_list as $value)
                                                            <option value="{{$value->id}}" 
                                                            @if(old('customer_cc_email') != '')
                                                                @if(in_array($value->id,old('customer_cc_email')))
                                                                    selected
                                                                @endif
                                                            @elseif(isset($selected_customer_id_cc))
                                                                @if(in_array($value->id,$selected_customer_id_cc))
                                                                    selected
                                                                @endif
                                                            @endif
                                                            >{{$value->email}} - {{$value->customer_users_name}}</option>
                                                        @endforeach  
                                                    @endif 
                                                </select>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Subject<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="name" class="form-control" name="name" value="{{{ old('name', isset($data) ? $data->name : null) }}}">
                                                    @if ($errors->has('name')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('name') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row" style="">
                                                <label class="col-md-2 label-control" for="mail_content">Mail Content</label>
                                                <div class="col-md-9">
                                                    <textarea id="mail_content" class="form-control" cols="5" name="mail_content">{{{ old('mail_content', isset($data) ? $data->mail_content : null) }}}</textarea>
                                                    @if ($errors->has('mail_content')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('mail_content') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row" style="display: none;">
                                                <label class="col-md-2 label-control" for="description">Description</label>
                                                <div class="col-md-9">
                                                    <textarea id="description" class="form-control" cols="5" name="description">{{{ old('description', isset($data) ? $data->description : null) }}}</textarea>
                                                    @if ($errors->has('description')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('description') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="send_date_value">Send Date<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="date" id="send_date_value" class="form-control" name="send_date_value" value="{{{ old('send_date_value', isset($data) ? $data->send_date_value : null) }}}">
                                                    @if ($errors->has('send_date_value')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('send_date_value') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="role_name">Schedule Period<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <?php 
                                                    $Scheduler_Reminder_Period_array = config('constants.Scheduler_Reminder_Period');
                                                    ?>
                                                    <select class="select2-size-lg form-control large-select"  id="reminder_period" name="reminder_period">
                                                        @if($Scheduler_Reminder_Period_array)
                                                            @foreach ($Scheduler_Reminder_Period_array as $value_key=>$value_data)
                                                            <option value="{{$value_key}}"
                                                            @if(old('reminder_period', isset($data) ? $data->reminder_period : null) == $value_key) selected @endif>{{$value_data}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('reminder_period')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('reminder_period') }}</div>
                                                    @endif
                                                </div>
                                            </div> 
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="assignment_id">Assignment<span class="required">*</span></label>
                                                <div class="col-md-7">
                                                    <select class="select2-size-lg form-control large-select"  id="assignment_id" name="assignment_id">
                                                        <option value="">Select Assignment</option>
                                                        @if(is_object($assignment))
                                                            @foreach ($assignment as $value)
                                                            @if(!$value->documents->isEmpty())
                                                                <option value="{{$value->id}}"
                                                                @if(old('assignment_id', isset($data) ? $data->assignment_id : null) == $value->id) selected @endif
                                                                >{{$value->name}}</option>
                                                            @endif    
                                                            @endforeach  
                                                        @endif
                                                    </select>
                                                    @if ($errors->has('assignment_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('assignment_id') }}</div>
                                                    @elseif ($errors->has('document_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('document_id') }}</div>
                                                    @endif
                                                </div>
                                                <div class="col-md-2"><a href="javascript:;" onclick="fun_get_assignment_by_document();" class="btn btn-danger mr-1 btn-sm">Document</a></div>
                                                @if(is_object($assignment))                                                
@foreach ($assignment as $value)
@if(!$value->documents->isEmpty())
<div class="modal fade" style="z-index: 106811;" id="document_id_Modal_{{$value->id}}" tabindex="-1" role="dialog" aria-labelledby="document_id_ModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="assignment_name_block">
                <strong>{{$value->name}} </strong>
                &nbsp;&nbsp;<input id="assigment_chk_{{$value->id}}" data-id="{{$value->id}}" class="all_select_unselect" type="checkbox" class="check_uncheck_all"> <small><label for="assigment_chk_{{$value->id}}">All Select / UnSelect</label></small>
                </h5>    
                <div class="row col-md-6" style="align-items: center;">
                    <div class="col-md-5 search-box-container-document">
                        <input data-filter_id="{{$value->id}}"  type="text" class="on-page-search" id="searchtxt_{{$value->id}}" />
                    </div>
                    <div class="col-md-7" id="searchcount_{{$value->id}}"></div>
                </div>
            
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body row" id="document_id_block">
        <?php
        $heading_wise_documents = array();
        foreach ($value->documents as $documents_val){
            $heading_wise_documents[$documents_val->heading_id][] = $documents_val;
        }
        ?>
        @foreach ($heading_wise_documents as $heading_key=>$heading_wise_documents_val)
            <div class="col-sm-3"><!-- heading_wise_block -->
            <?php $heading_name = \App\Helper\Helpers::GetHeadingName($heading_key);?>
            <h3 style="font-weight: 700;">{{$heading_name}}</h3>
            @foreach ($heading_wise_documents_val as $documents_val)
                <div class="">
                    <?php $style_doc_checked = 'display:none1';?> <?php // onchange="fun_doc_selected('{{$documents_val->id}}')" ?>
                    <input type="checkbox" name="document_id[{{$value->id}}][]" class="assigment_{{$value->id}}" id="document_id_{{$documents_val->id}}" value="{{$documents_val->id}}"
                    @if(old('document_id') != '')
                        @if(!empty(old('document_id')[$value->id]))
                        @if(in_array($documents_val->id,old('document_id')[$value->id]))
                            <?php $style_doc_checked = 'display:inline-block';?>
                            checked
                        @endif
                        @endif
                    @elseif(isset($selected_document_id))
                        @if(in_array($documents_val->id,$selected_document_id))
                            <?php $style_doc_checked = 'display:inline-block';?>
                            checked
                        @endif
                    @endif
                    >
                    <label for="document_id_{{$documents_val->id}}" style="display: inline;"><strong  class="inner-list-doc-{{$value->id}}">{{$documents_val->name}}</strong></label>
                    @if($documents_val->doc_content != '')
                        <?php 
                        //$string = "{{name}} is my name.\nBirth date: {{BirthDate}}";
                        $string = $documents_val->doc_content;
                        // Regular expression to match the content within {{ }}
                        preg_match_all('/{{{(.*?)}}}/', $string, $matches);
                        // $matches[1] will contain all the placeholder names
                        $placeholderNames = $matches[1];
                        // Output the placeholder names
                        $field_name_array = array();
                        foreach ($placeholderNames as $placeholder) {
                            $field_name_array[] = $placeholder;
                        }
                        $field_name_array = array_unique($field_name_array);
                        $del_val = 'CLIENTNAME';
                        if (($key = array_search($del_val, $field_name_array)) !== false) {
                            unset($field_name_array[$key]);
                        } 
                        $del_val = 'CLIENTADDRESS';
                        if (($key = array_search($del_val, $field_name_array)) !== false) {
                            unset($field_name_array[$key]);
                        } 
                        $del_val = 'CurrentDate';
                        if (($key = array_search($del_val, $field_name_array)) !== false) {
                            unset($field_name_array[$key]);
                        } 
                        $del_val = 'YearEndDate';
                        if (($key = array_search($del_val, $field_name_array)) !== false) {
                            unset($field_name_array[$key]);
                        }
                        if(count($field_name_array) > 0){   
                        ?>
                        <a href="javascript:;" style="{{$style_doc_checked}} padding: 2px 4px;" id="edit_doc_content_btn_{{$documents_val->id}}" class="" onclick="fun_doc_content_btn('{{$documents_val->id}}')" document-id="{{$documents_val->id}}" title="Manage Field"><i style="font-size: 25px;" class="fa fa-edit" aria-hidden="true"></i></a>
                        <?php } ?>
                        <?php //data-toggle="modal" data-target="#edit_doc_content_{{$documents_val->id}}"?>
                        <div class="modal fade" id="edit_doc_content_{{$documents_val->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                            <div class="modal-dialog  modal-lg" role="document">
                                <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">Fill Detail</h5>
                                    <button type="button" class="close" onclick="fun_document_modal_close('{{$documents_val->id}}')" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <?php 
                                    if(count($field_name_array) > 0){
                                        $doc_content_column = isset($fill_doc_content_column[$documents_val->id]) ? $fill_doc_content_column[$documents_val->id] : array();
                                        ?>
                                        <table class="table table-responsive-lg" id="" style="">
                                            @foreach ($field_name_array as $field_name_array_val)
                                                <?php 
                                                $field_name_array_val = strip_tags($field_name_array_val);    
                                                ?>
                                                <tr>
                                                    <th>{{$field_name_array_val}}</th>
                                                    <?php 
                                                    $fill_data = '';
                                                    ?>
                                                    @if(old('doc_content_column') != '')
                                                    <?php 
                                                    $fill_data = isset(old('doc_content_column')[$documents_val->id][$field_name_array_val]) ? old('doc_content_column')[$documents_val->id][$field_name_array_val] : '';
                                                    ?>
                                                    @elseif(count($doc_content_column) > 0)
                                                    <?php 
                                                    $fill_data = isset($doc_content_column[$field_name_array_val]) ? $doc_content_column[$field_name_array_val] : '';
                                                    ?>   
                                                    @endif
                                                    <td><input type="text" name="doc_content_column[{{$documents_val->id}}][{{$field_name_array_val}}]" class="form-control" value="{{$fill_data}}"></td>
                                                </tr>
                                            @endforeach
                                            <tr>
                                                <th></th>
                                                <td><button type="button" class="btn btn-primary" onclick="fun_document_modal_close('{{$documents_val->id}}')">Update</button></td>
                                            </tr>
                                        </table>
                                        <?php
                                    }
                                    ?>
                                    <?php /* 
                                    <hr>
                                    {!!$documents_val->doc_content!!}
                                    */ ?>
                                </div>
                                <!-- <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div> -->
                                </div>
                            </div>
                            </div>
                    @endif
                </div>
            @endforeach
            </div>
        @endforeach
        </div>
        <div class="modal-footer" style="justify-content: center;">
            <button type="button" class="btn btn-primary"  data-dismiss="modal">Ok</button>
        </div>
        </div>
    </div>
</div>
@endif
@endforeach
@endif
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="attachment">Attachment</label>
                                                <div class="col-md-9">
                                                <input type="file" name="attachment[]" id="attachment" class="form-control" value="" multiple>
                                                </div>
                                            </div>
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Save & Exit">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Save">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<style>
    .btn-group{
        width:100%;
    }
    .multiselect-container.dropdown-menu {
        margin-top:0px !important;
        max-height: 380px !important;
        overflow-x: hidden !important;
        overflow-y: scroll !important;
        width:100%;
    }
    .caret {
       /* float: right;
        border-top: 7px dashed !important;
        border-top: 4px solid\9 !important;
        border-right: 7px solid transparent !important;
        border-left: 7px solid transparent !important;
        margin-top: 6px;*/
    }
    .multiselect.dropdown-toggle {
      text-align: left !important;
     /* width: 100%;*/
    }
    </style>
@endsection
@section('js')
<link rel="stylesheet" href="{{ asset('/app-assets/multiselect/css/bootstrap-multiselect.css') }}" type="text/css">
<script type="text/javascript" src="{{ asset('/app-assets/multiselect/js/bootstrap-multiselect.js') }}"></script>
<!-- <script src="https://www.jqueryscript.net/demo/Two-side-Multi-Select-Plugin-with-jQuery-multiselect-js/js/multiselect.js"></script> -->
<script type="text/javascript">
    $(document).ready(function() {
        /*$('#customer_id').select2({
            placeholder: "Select Customer", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
        $('#customer_to_email').select2({
            placeholder: "Select To Email", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
        $('#customer_cc_email').select2({
            placeholder: "Select CC Email", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
        $('#assignment_id').select2({
            placeholder: "Select Assignment", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });*/
        $('#group_id').multiselect({
            enableFiltering: true,
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true,
            maxHeight: 400,
            dropUp: true
        });
        $('#customer_id').multiselect({
            enableFiltering: true,
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true,
            maxHeight: 400,
            dropUp: true
        });
        $('#customer_to_email').multiselect({
            enableFiltering: true,
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true,
            maxHeight: 400,
            dropUp: true
        });
        $('#customer_cc_email').multiselect({
            enableFiltering: true,
            enableCaseInsensitiveFiltering: true,
            includeSelectAllOption: true,
            maxHeight: 400,
            dropUp: true
        });
        $('#group_id').change(function() {
            var Selected = $('#group_id').find("option:selected");
            var arrSelected = [];
            var arrgroupSelected = [];
            Selected.each(function(){
                arrgroupSelected.push($(this).val());
            });
            group_id = 'all'
            customer_search = '';//$('#customer_search').val();
            var selected = $('#customer_id').find("option:selected");
            var arrcustomerSelected = [];
            selected.each(function(){
                arrcustomerSelected.push($(this).val());
            });
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url : "{{ url('get_group_by_customer') }}/"+group_id,    
                data: {'group_id':group_id,'arrgroupSelected':arrgroupSelected,'arrcustomerSelected':arrcustomerSelected,'arrSelected':arrSelected,'customer_search':customer_search},   
                type : 'post',
                dataType : 'json',
                beforeSend : function(data){
                    //$('.loader_block').show();
                }
            }).done(function(data) {
            // Code to execute if the request is successfulbeforeSend
                $('#customer_id').empty();
                //$('#customer_to_email').empty();
                //$('#customer_cc_email').empty();
                $.each(data, function(key, customer_detail) {
                    console.log(customer_detail.email_address);
                    var selected = customer_detail.customer_to_email_selected;
                    $('#customer_id').append('<option value="' + customer_detail.id + '" '+selected+ '>' + customer_detail.name + '</option>');
                });
                $("#customer_id").multiselect('rebuild');
                //$("#customer_to_email").multiselect('rebuild');
                //$("#customer_cc_email").multiselect('rebuild');
                fun_change_customer_id();
                //$('.loader_block').hide();
            }).fail(function(jqXHR, textStatus, errorThrown) {
            // Code to execute if the request fails
                console.error("Request failed: " + textStatus);
            });
        }); 
    });
    $('#customer_id').change(function() {
        fun_change_customer_id();
    });    
    function fun_change_customer_id(){
        var selected = $('#customer_id').find("option:selected");
        var arrSelected = [];
        selected.each(function(){
            arrSelected.push($(this).val());
        });
        var selected_customer_to_email = $('#customer_to_email').find("option:selected");
        var arrSelected_customer_to_email = [];
        selected_customer_to_email.each(function(){
            arrSelected_customer_to_email.push($(this).val());
        });
        var selected_customer_cc_email = $('#customer_cc_email').find("option:selected");
        var arrSelected_customer_cc_email = [];
        selected_customer_cc_email.each(function(){
            arrSelected_customer_cc_email.push($(this).val());
        });
        customer_search = '';//$('#customer_search').val();
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url : "{{ url('get_customer_contact_details') }}",      
            data: {'arrSelected':arrSelected,'arrSelected_customer_to_email':arrSelected_customer_to_email,'arrSelected_customer_cc_email':arrSelected_customer_cc_email,'customer_search':customer_search},  
            type : 'post',
            dataType : 'json',
            beforeSend : function(data){
                //$('.loader_block').show();
            }
        }).done(function(data) {
        // Code to execute if the request is successfulbeforeSend
            $('#customer_to_email').empty();
            $.each(data, function(key, customer_contact) {
                var selected = customer_contact.customer_to_email_selected;
                $('#customer_to_email').append('<option value="' + customer_contact.id + '" '+selected+ '>' + customer_contact.email + '</option>');
            });
            $("#customer_to_email").multiselect('rebuild');
            $('#customer_cc_email').empty();
            $.each(data, function(key, customer_contact) {
                var selected = customer_contact.customer_cc_email_selected;
                $('#customer_cc_email').append('<option value="' + customer_contact.id + '" '+selected+ '>' + customer_contact.email + '</option>');
            });
            $("#customer_cc_email").multiselect('rebuild');
            //$('.loader_block').hide();
        }).fail(function(jqXHR, textStatus, errorThrown) {
        // Code to execute if the request fails
            console.error("Request failed: " + textStatus);
        });
    }   
</script>
<script type="text/javascript">
    function fun_frm_submit(){
        $('.loader_block').show();
    }
    $('#assignment_id').change(function() {
        assignment_id = $(this).val();
        if(assignment_id == ''){
        }else{
            $('#document_id_Modal_'+assignment_id).modal('show');
        }
    });
    function fun_document_modal_close(documents_id){
        $('#edit_doc_content_'+documents_id).modal('hide');
    }
    function fun_get_assignment_by_document(){
        assignment_id = $('#assignment_id').val();
        if(assignment_id == ''){
            alert('Please Select Assignment');
            return false;
        }
        $('#document_id_Modal_'+assignment_id).modal('show');
    }
</script>
<script type="text/javascript">
    function fun_doc_selected(document_id){
        if($('#document_id_'+document_id).prop('checked') == true){
            $('#edit_doc_content_btn_'+document_id).show();
        }else{
            $('#edit_doc_content_btn_'+document_id).hide();
        }
    }
    function fun_doc_content_btn(document_id){
        if($('#document_id_'+document_id).prop('checked') == true){
            $('#edit_doc_content_'+document_id).modal('show');
        }else{
            alert('Please Check Document');
        }
    }
    $('.all_select_unselect').change(function(){
        assigment_id = $(this).attr('data-id');
        if($(this).prop('checked') == true){
            $('.assigment_'+assigment_id).attr('checked',true);
        }else{
            $('.assigment_'+assigment_id).attr('checked',false);
        }
    })    
    $(".on-page-search").on("keyup", function() {
        var filter_id = $(this).attr('data-filter_id');
        $('#searchcount_'+filter_id).html('');
        var searchtxt = $('#searchtxt_'+filter_id).val();
        $(".highlight").removeClass("highlight");
        $(".noresults").removeClass("noresults");
        $(".inner-list-doc-"+filter_id).each(function() {
            if (searchtxt != "" && $(this).text().search(new RegExp(searchtxt, 'gi')) != -1) {
                $(this).addClass("highlight");
            } else if (searchtxt != "" && $(this).text().search(searchtxt) != 1) {
                $(this).addClass("noresults");
            }
        });
        if(searchtxt != ''){
            var numItems = $(".inner-list-doc-"+filter_id+'.highlight').length;
            $('#searchcount_'+filter_id).html('<span class="highlight_lenght">'+numItems+' Results Found</span>');
        }    
    });
</script>
@endsection
