@extends('admin.layout.main')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-4 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($state)) 
                        Edit 
                    @else 
                        Add 
                    @endif
                    State Management
                </h3>
            </div>
            <div class="content-header-right col-md-8 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('state.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($state)){{ route('state.update',$state->id) }} @else{{ route('state.store') }}@endif">
                                        @csrf
                                        @if(isset($state))
                                            @method('PUT')
                                            <input type="hidden" name="id" value="{{ $state->id }}" />
                                        @endif
                                        <div class="form-body">	                    		
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Country<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select"  id="country_id" name="country_id">
                                                        <option value="">Select Country</option>
                                                        @if(is_object($country))
                                                            @foreach ($country as $value)
                                                            <option value="{{$value->id}}"
                                                            @if(old('country_id', isset($state) ? $state->country_id : null) == $value->id) selected @elseif($value->name == 'India') selected @endif>{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('country_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('country_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">State Name<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="name" autocomplete="off" class="form-control input-suggestion" name="name" value="{{{ old('name', isset($state) ? $state->name : null) }}}">
                                                    @if(is_object($states) && count($states) > 0)
                                                    <datalist role="listbox" class="suggetion-datalist">
                                                        @foreach($states as $state)
                                                        <option value="{{ $state->name }}">{{$state->name}}, {{ $state->Country->name }}.</option>
                                                        @endforeach
                                                    </datalist>
                                                    @endif
                                                    @if ($errors->has('name')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('name') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <!-- <div class="form-group row">
                                                <label class="col-md-2 label-control" for="sequence">Sort order<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="number" id="sequence" class="form-control" name="sequence" value="{{{ old('sequence', isset($state) ? $state->sequence : null) }}}">
                                                    @if ($errors->has('sequence')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('sequence') }}</div>
                                                    @endif
                                                </div>
                                            </div> -->
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Save & Exit">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Save">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">
function fun_frm_submit() {
    error = 0;
    $('.loader_block').show();
}
$('#country_id').select2({
    placeholder: "Select Country", // Optional: add a placeholder
    allowClear: true // Optional: allows the user to clear the selection
});
</script>
@endsection
