@extends('customer.layout.main')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    Reminder Detail
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('customer.document.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    
                                    <form method="POST" enctype="multipart/form-data" action="{{ route('customer.document.postdetail',$reminder_id) }}">
                                        @csrf
                                        <input type="hidden" name="reminder_id" value="{{ $reminder_id }}" />
                                        <div class="form-body">
                                            <?php 
                                            if (is_object($reminder_detail)) {
                                                $name = $reminder_detail->name;
                                                $description = $reminder_detail->description;
                                                ?>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="name">Reminder Name</label>
                                                    <div class="col-md-9">
                                                        {{$name}} <br><small>{{$description}}</small>
                                                    </div>
                                                </div>
                                                @if($document_list)
                                                    @foreach ($document_list as $Document_val)
                                                        @if($Document_val->Document)
                                                        <div class="form-group row">
                                                            <label class="col-md-2 label-control" for="name">
                                                            {{$Document_val->Document->name}}
                                                            <br><small>{{$Document_val->Document->description}}</small>
                                                            </label>
                                                            <div class="col-md-9">
                                                                <input type="file" name="upload_document[{{$Document_val->id}}]" id="upload_document_{{$Document_val->id}}" class="form-control" value="">
                                                                @php
                                                                $document_file = \App\Helper\Helpers::GetDocument($Document_val->id);
                                                                @endphp
                                                                {!!$document_file!!}
                                                            </div>
                                                        </div>
                                                        @endif
                                                    @endforeach
                                                @endif
                                                <?php 
                                            }    
                                            ?>
                                        </div>
                                        <div class="form-actions center">
                                            <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Upload">
                                            <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">

</script>
@endsection
