@extends('customer.layout.main')
@section('content')
<style>
    .form-check {
        margin-bottom: 6px !important;
    }
</style>
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-4 col-12 mb-2">
                <h3 class="content-header-title">Reminder Management</h3>
            </div>
            <div class="content-header-right col-md-8 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <!-- <a href="{{ route('country.create') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red add_btn btn-sm"><i class="fa fa-plus" aria-hidden="true"></i> Add</button></a> -->
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="row">
                            <div class="col-md-12 card-content collapse show" style="background-color: #ffffff;">
                                <div class="table-responsive">
                                    <div class="bd-example">
                                        <table class="table table-responsive-lg" id="document_table_view" style="text-align: center;">
                                            <thead>
                                                <tr>
                                                    <th scope="col">Reminder</th>
                                                    <th scope="col">Date</th>
                                                    <th scope="col">Status</th>
                                                    <th scope="col">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script type="text/javascript">
    var table = $('#document_table_view').DataTable({
        processing: true,
        serverSide: true,
        pageLength: '{{config("constants.PAR_PAGE_LENGHT")}}',
        ajax: "{{ route('customer.document.index') }}",
        aaSorting: [],
        aoColumnDefs: [{
            bSortable: true,
            sType: "numeric",
            aTargets: [0],
            /*mRender: function(data, type) {
                var color = data['color'] != null && data['color'] != ''  ? data['color'] : '' ;
                var status = data['status'] != null && data['status'] != '' ? data['status'] : '';
                var html = '<span class="badge badge-'+color+' font-medium-1">'+status+'</span>';
                return html;
            },*/
        }],
        columns: [{
                data: 'reminder_name',
                name: 'reminder_name',
                className: 'text-left'
            },
            {
                data: 'date',
                name: 'date',
                className: 'text-left'
            },
            {
                data: 'status',
                name: 'status',
                className: 'text-left'
            },
            {
                data: 'action',
                name: 'action',
                orderable: false,
                searchable: false,
                className: 'text-left'
            },
        ]
    });
    
</script>
@endsection