@extends('customer.layout.main')
@section('css')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
<style>
    
</style>
@endsection
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-4 col-12 mb-2">
                <h3 class="content-header-title">
                    Change Password
                </h3>
            </div>
            <div class="content-header-right col-md-8 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="{{ route('customer.changePassword.post') }}">
                                        @csrf
                                        <div class="form-body">	 
                                        <div class="form-group row">
                                                <label class="col-md-2 label-control" for="current_password">Current Password</label>
                                                <div class="col-md-9">
                                                    <div class="input-group">
                                                        <input type="password" id="current_password" class="form-control" name="current_password" value="{{ old('current_password') }}">
                                                        <div class="input-group-append">
                                                            <span class="input-group-text eye-icon-square" onclick="togglePasswordVisibility('current_password', 'currentt_password')" id="currentt_password">
                                                                <i class="fa fa-eye" id="toggle-current-password"></i>
                                                            </span>
                                                        </div>
                                                    </div>
                                                    @if ($errors->has('current_password')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('current_password') }}</div>
                                                    @endif
                                                    @if(Session::get('error_current_password') && Session::get('error_current_password') != null)
                                                        <div class="errors_msg text-danger">{{ Session::get('error_current_password') }}</div>
                                                        @php
                                                            Session::put('error_current_password', null)
                                                        @endphp
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="new_password">New Password</label>
                                                <div class="col-md-9">
                                                    <div class="input-group">
                                                        <input type="password" id="new_password" class="form-control" name="new_password" value="{{ old('new_password') }}">
                                                        <div class="input-group-append">
                                                            <span class="input-group-text eye-icon-square" onclick="togglePasswordVisibility('new_password', 'neww_password')" id="neww_password">
                                                                <i class="fa fa-eye" id="toggle-new-password"></i>
                                                            </span>
                                                        </div>
                                                    </div>
                                                    @if ($errors->has('new_password')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('new_password') }}</div>
                                                    @endif
                                                    @if(Session::get('error_not_match') && Session::get('error_not_match') != null)
                                                        <div class="errors_msg text-danger">{{ Session::get('error_not_match') }}</div>
                                                        @php
                                                            Session::put('error_not_match', null)
                                                        @endphp
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="form-group row">
    <label class="col-md-2 label-control" for="new_password_confirmation">Confirm New Password</label>
    <div class="col-md-9">
        <div class="input-group">
            <input type="password" id="new_password_confirmation" class="form-control" name="new_password_confirmation" value="{{ old('new_password_confirmation') }}">
            <div class="input-group-append">
                <span class="input-group-text eye-icon-square" onclick="togglePasswordVisibility('new_password_confirmation', 'confirm_password')" id="confirm_password">
                    <i class="fa fa-eye" id="toggle-confirm-password"></i>
                </span>
            </div>
        </div>
        @if ($errors->has('new_password_confirmation')) 
            <div class="errors_msg text-danger">{{ $errors->first('new_password_confirmation') }}</div>
        @endif
    </div>
</div>

                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Update">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">
function fun_frm_submit(){
    $('.loader_block').show();
}
function togglePasswordVisibility(inputId,selectedId) {
        var passwordField = document.getElementById(inputId);
        var toggleIcon = document.getElementById('toggle-' + inputId);

        if (passwordField.type === "password") {
            passwordField.type = "text";
            $('#'+selectedId).html('<i class="fa fa-eye-slash"></i>');
            // toggleIcon.innerHTML = '<i class="fa fa-eye-slash"></i>';
        } else {
            passwordField.type = "password";
            // toggleIcon.innerHTML = '<i class="fa fa-eye"></i>';
            $('#'+selectedId).html('<i class="fa fa-eye"></i>');
        }
    }
</script>
@endsection

