@extends('customer.layout.main')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    Edit Profile Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('customer.dashboard') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    
                                    <form method="POST" enctype="multipart/form-data" action="{{ route('customer.profile.update') }}">
                                        @csrf
                                        <input type="hidden" name="user_id" value="{{ $customer_user->id }}" />
                                        <div class="form-body">
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Name<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" name="name" placeholder="Name" id="name" class="form-control" value="{{ old('name',!empty($customer_user->name) ? $customer_user->name : '') }}">
                                                    @if ($errors->has('name'))
                                                    <div class="errors_msg text-danger">{{ $errors->first('name') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Email</label>
                                                <div class="col-md-9">
                                                    <input type="text" readonly placeholder="Email" id="email" class="form-control" value="{{ old('email_address',!empty($customer_user->email_address) ? $customer_user->email_address : '') }}">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="address">Address</label>
                                                <div class="col-md-9">
                                                    <textarea id="address" class="form-control" placeholder="Address" name="address">{{{ old('address', isset($customer_user) ? $customer_user->address : null) }}}</textarea>
                                                    @if ($errors->has('address')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('address') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="phone_number">Phone Number<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="number" name="phone_number" pattern="/^-?\d+\.?\d*$/" onKeyPress="if(this.value.length==10) return false;" placeholder="Phone Number" id="phone_number" class="form-control" value="{{ old('phone_number', !empty($customer_user->phone_number) ? $customer_user->phone_number : '') }}">
                                                    @if ($errors->has('phone_number'))
                                                    <div class="errors_msg text-danger">{{ $errors->first('phone_number') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Country<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select"  id="country" name="country">
                                                        <option value="">Select Country</option>
                                                        @if(is_object($country))
                                                            @foreach ($country as $value)
                                                            <option value="{{$value->id}}"
                                                            @if(old('country', isset($customer_user) ? $customer_user->country_id : null) == $value->id) selected @elseif($value->name == 'India') selected @endif>{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('country')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('country') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">State<span class="required">*</span></label>
                                                <div class="col-md-9" id="state_section">
                                                    <select class="select2-size-lg form-control large-select"  id="state" name="state">
                                                        
                                                    </select>
                                                    @if ($errors->has('state')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('state') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-lg-2 col-md-4 label-control" for="city">City<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select" id="city" name="city">
                                                        
                                                    </select>
                                                    @if ($errors->has('city')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('city') }}</div>
                                                    @endif 
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="district">District<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" name="district" placeholder="District" id="district" class="form-control" value="{{ old('district', !empty($customer_user->district) ? $customer_user->district : '') }}">
                                                    @if ($errors->has('district'))
                                                    <div class="errors_msg text-danger">{{ $errors->first('district') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="pincode_number">Pin Code Number<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="number" name="pincode_number" pattern="/^-?\d+\.?\d*$/" onKeyPress="if(this.value.length==6) return false;" placeholder="Pin Code Number" id="pincode_number" class="form-control" value="{{ old('pincode_number', !empty($customer_user->pincode_number) ? $customer_user->pincode_number : '') }}">
                                                    @if ($errors->has('pincode_number'))
                                                    <div class="errors_msg text-danger">{{ $errors->first('pincode_number') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <hr>
                                        <hr>
                                        <div class="form-actions center">
                                            <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Update">
                                            <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">

    $(function(){
        var dtToday = new Date();
        var month = dtToday.getMonth() + 1;
        var day = dtToday.getDate();
        var year = dtToday.getFullYear();
        if(month < 10)
            month = '0' + month.toString();
        if(day < 10)
            day = '0' + day.toString();
        
        var maxDate = year + '-' + month + '-' + day;
        
        $('#opening_date').attr('max', maxDate);
    });

    $(document).ready(function() {
        $('#country').select2({
            placeholder: "Select Country", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
        $('#state').select2({
            placeholder: "Select State", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
        $('#city').select2({
            placeholder: "Select City", // Optional: add a placeholder
            allowClear: true // Optional: allows the user to clear the selection
        });
    });

    function getState(country_id, state_id = null) {
        if (country_id) {
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ url('getState') }}" + '/' + country_id,
                type: 'GET',
                dataType: 'json',
                beforeSend: function(data) {
                    $('.loader_block').show();
                }
            }).done(function(data) {
                // Code to execute if the request is successfulbeforeSend
                $('#state').empty();
                if (state_id == null) {
                    $('#city').empty();
                }

                $('#state').append('<option value="">Select State</option>');
                $.each(data, function(key, state) {
                    var selected = state.id == state_id ? 'selected' : '';
                    $('#state').append('<option value="' + state.id + '" ' + selected + '>' + state.name + '</option>');
                });
                $('#state').prop('disabled', false);
                $('.loader_block').hide();

            }).fail(function(jqXHR, textStatus, errorThrown) {
                // Code to execute if the request fails
                console.error("Request failed: " + textStatus);
            });
        } else {
            $('#state').empty();
            $('#state').append('<option value="">Select State</option>');
            $('#state').prop('disabled', true);
            $('#city').empty();
            $('#city').append('<option value="">Select City</option>');
            $('#city').prop('disabled', true);
            $('.loader_block').hide();
        }
    }

    function getCity(state_id, city_id = null) {
        if (state_id) {
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ url('getCity') }}" + '/' + state_id,
                type: 'GET',
                dataType: 'json',
                beforeSend: function(data) {
                    $('.loader_block').show();
                }
            }).done(function(data) {
                // Code to execute if the request is successful
                $('#city').empty();
                $('#city').append('<option value="">Select City</option>');
                $.each(data, function(key, city) {
                    var selected = city.id == city_id ? 'selected' : '';
                    $('#city').append('<option value="' + city.id + '" ' + selected + '>' + city.name + '</option>');
                });
                $('#city').prop('disabled', false);
                $('.loader_block').hide();

            }).fail(function(jqXHR, textStatus, errorThrown) {
                // Code to execute if the request fails
                console.error("Request failed: " + textStatus);
            });
        } else {
            $('#city').empty();
            $('#city').append('<option value="">Select City</option>');
            $('#city').prop('disabled', true);
            $('.loader_block').hide();
        }
    }

    $('#country').on('change', function() {
        var country_id = this.value;
        getState(country_id);
    });
    $('#state').on('change', function() {
        var state_id = this.value;
        getCity(state_id);
    });

    @if(old('country'))
        getState('{{old("country")}}', '{{old("state")}}');
    @elseif(isset($customer_user) && $customer_user->country_id)
        getState('{{$customer_user->country_id}}', '{{$customer_user->state_id}}');
    @else
        getState('1');
    @endif

    @if(old('state'))
        getCity('{{old("state")}}', '{{old("city")}}');
    @elseif(isset($customer_user) && $customer_user->state_id)
        getCity('{{$customer_user->state_id}}', '{{$customer_user->city_id}}');
    @endif
</script>
@endsection
