<!DOCTYPE html>
<html lang="en">

<head>
  <meta name="viewport" content="initial-scale=1,maximum-scale=1,user-scalable=no" />
   <meta name="apple-mobile-web-app-capable" content="yes">
  <title>Digital Business Card</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #f7f7f7;
      display: flex;
      justify-content: center;
      padding: 20px;
    }

    .card {
      background: white;
      width: 360px;
      padding: 20px;
      border-radius: 12px;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
      text-align: center;
    }

    .logo {
      max-width: 120px;
      margin-bottom: 10px;
    }

    .profile-detail .profile {
      border-radius: 50%;
      margin: 10px 0;
      height: 120px;
      width: 120px;
      object-fit: cover;
      object-position: 0px -2px;
      position: absolute;
      left: 50%;
      transform: translateX(-50%);
      top: -78px;
      border: 2px solid #cccccc38;
      padding: 5px;
      background-color: #ffffff;
    }

    .profile-inner {
      box-shadow: 0 0 13px -3px #ccc;
      border-radius: 20px;
      margin-top: 20px;
      padding: 30px;
      position: relative;
      margin-top: 80px;
    }

    .profile-detail h2 {
      margin: 50px 0 5px;
      font-size: 20px;
    }

    p.title {
      font-weight: bold;
      color: #555;
      margin-bottom: 5px;
    }

    p.company {
      color: #888;
      margin-bottom: 15px;
    }

    .contact-info {
      text-align: left;
      margin: 0 auto 15px;
    }

    .contact-info div {
      display: flex;
      align-items: center;
      margin: 8px 0;
      font-size: 14px;
      color: #333;
    }

    .contact-info i {
      margin-right: 10px;
      background-color: #000000;
      color: #ffffff;
      width: 30px;
      height: 30px;
      border-radius: 50%;
      text-align: center;
      line-height: 30px;
    }

    .contact-info a {
      text-decoration: none;
    }

    .share-button {
      background-color: #000;
      color: #fff;
      padding: 10px 0;
      border-radius: 30px;
      font-weight: 600;
      text-decoration: none;
      display: inline-block;
      width: 100%;
    }

    div a {
      color: #000000;
    }
/* Modal Styles */
.modal {
  display: none;
  position: fixed;
  z-index: 999;
  padding-top: 80px;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  overflow: auto;
  background-color: rgba(0,0,0,0.4);
}

.modal-content {
  background-color: white;
  margin: auto;
  padding: 20px;
  border-radius: 8px;
  width: 250px;
  text-align: left;
  box-shadow: 0 0 10px #aaa;
}

.modal-content a {
  display: block;
  margin: 10px 0;
  text-decoration: none;
  color: #000000;
  font-size: 16px;
}

.modal-content a i {
  margin-right: 10px;
}

.close {
  float: right;
  font-size: 20px;
  font-weight: bold;
  cursor: pointer;
}
  </style>
</head>

<body>
  @if(is_object($emp_detail))
  <div class="card profile-detail">
    <img src="{{asset('app-assets/images/logo/logo1.png')}}" alt="Logo" class="logo">
    <br>
    <div class="profile-inner">
      <?php 
            $logo_image_url = isset($emp_detail) ? $emp_detail->logo_image_url : '';
            ?>
      @if($logo_image_url != '')
      <img src="{{$logo_image_url  }}" alt="Profile Picture" class="profile">
      @endif
      <h2>{{ isset($emp_detail) ? $emp_detail->name : null }}</h2>
      <p class="title">{{ is_object($emp_detail) ? $emp_detail->designation : null }}</p>
      <p class="company">
        {{ isset($emp_detail) ? $emp_detail->address : null}}
        {{ isset($emp_detail) ? $emp_detail->address_1 : null}}
        {{ isset($emp_detail) ? $emp_detail->address_2 : null}}
      </p>
      <div class="contact-info">
        <?php 
                $phonecode = isset($emp_detail) ? $emp_detail->phonecode : '';
                $phone_number = isset($emp_detail) ? $emp_detail->phone_number : '';
                $phone_number_view = $phonecode.$phone_number
                ?>
        <div><i class="fas fa-phone"></i> <a href="tel:{{ $phone_number_view }}">{{ $phone_number_view }}</a></div>
        <?php 
                $email_address = isset($emp_detail) ? $emp_detail->email_address : '';
                ?>
        <div><i class="fas fa-envelope"></i><a href="mailto:{{ $email_address }}">{{ $email_address }}</a></div>
        <?php 
                $website = isset($emp_detail) ? $emp_detail->website : '';
                ?>
        @if($website)
        <div><i class="fas fa-globe"></i><a target="_" href="{{$website }}">{{$website }}</a></div>
        @endif
      </div>
      <?php 
      $id = $emp_detail->id;
      $id = base64_encode($id);
      $link_url = route('employee_detail.get', array('id' => $id));
      ?>
      <a href="javascript:;" id="openShare" class="share-button"><i class="far fa-paper-plane"></i> Share</a>
      <div id="shareModal" class="modal">
      <div class="modal-content">
        <span class="close">&times;</span>
        <p><a target="_blank" href="{{ $link_url }}" id=""><i class="fas fa-eye"></i> View Profile</a></p>
        <p><a href="javascript:;" id="" onclick="copyText('{{ $link_url }}')"><i class="fas fa-solid fa-copy"></i> Copy Profile</a></p>
        <p><a target="_blank" href="mailto:{{ $email_address }}" id=""><i class="fas fa-envelope"></i>Email</a></p>
        <p style=""><a href="https://www.facebook.com/sharer/sharer.php?u={{ $link_url }}" target="_blank">
          <i class="fab fa-facebook"></i> Share on Facebook
        </a></p>
        <p style=""><a href="https://api.whatsapp.com/send?text={{ $link_url }}" target="_blank">
          <i class="fab fa-whatsapp"></i> Share on WhatsApp
        </a></p>
        <p style=""><a href="https://www.linkedin.com/sharing/share-offsite/?url={{ $link_url }}" target="_blank">
          <i class="fab fa-linkedin"></i> Share on LinkedIn
        </a></p>
        <p style="display: none;"><a href="https://twitter.com/intent/tweet?url={{ $link_url }}" target="_blank">
          <i class="fab fa-twitter"></i> Share on Twitter
        </a></p>
      </div>
    </div>
    @if($emp_detail->profile_image_url != '')
    @endif  
    </div>
  </div>
  @else
  <div class="card">
    <p>No Detail Found.</p>
  </div>
  @endif
</body>
<script>
function copyText(url) {
    navigator.clipboard.writeText(url);
    alert("Copied!");
}
</script>
<script>
  var modal = document.getElementById("shareModal");
  var btn = document.getElementById("openShare");
  var span = document.getElementsByClassName("close")[0];

  btn.onclick = function () {
    modal.style.display = "block";
  }

  span.onclick = function () {
    modal.style.display = "none";
  }

  window.onclick = function (event) {
    if (event.target == modal) {
      modal.style.display = "none";
    }
  }
</script>
</html>