@extends('customer.layout.main_without_login')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    Reminder Detail
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    
                                    <form method="POST" enctype="multipart/form-data" action="{{ route('upload.postdocument',$reminder_id) }}">
                                        @csrf
                                        <input type="hidden" name="reminder_id" value="{{ $reminder_id }}" />
                                        <input type="hidden" name="customer_id" value="{{ $customer_id }}" />
                                        <div class="form-body">
                                            <?php 
                                            if (is_object($reminder_detail)) {
                                                $name = $reminder_detail->name;
                                                $description = $reminder_detail->description;
                                                ?>
                                                <div class="form-group row">
                                                    <label class="col-md-2 label-control" for="name">Reminder Name</label>
                                                    <div class="col-md-9">
                                                        {{$name}} <br><small>{{$description}}</small>
                                                    </div>
                                                </div>
                                                @if($document_list)
                                                    @foreach ($document_list as $Document_val)
                                                        @if($Document_val->Document)
                                                        <div class="form-group row">
                                                            <label class="col-md-2 label-control" for="name" style="margin-top: 3%;">
                                                            {{$Document_val->Document->name}}
                                                            <br><small>{{$Document_val->Document->description}}</small>
                                                            </label>
                                                            @php
                                                            $document_file = \App\Helper\Helpers::GetDocument($Document_val->id);
                                                            $reject_note = \App\Helper\Helpers::GetDocumentRejectNotes($Document_val->id);
                                                            @endphp
                                                            @if($document_file == '')
                                                                <div class="col-md-6">
                                                                    {!!$reject_note!!}
                                                                    <input multiple type="file" name="upload_document[{{$Document_val->id}}][]" id="upload_document_{{$Document_val->id}}" class="form-control" value="">
                                                                    {!!$document_file!!}
                                                                    <br>
                                                                    <textarea name="upload_comment[{{$Document_val->id}}]" id="upload_comment_{{$Document_val->id}}" class="form-control" placeholder="Comment">{{$Document_val->upload_comment}}</textarea>
                                                                </div>
                                                                <div class="col-md-3">
                                                                    @php
                                                                    $document_file = \App\Helper\Helpers::GetDocument($Document_val->id,'doc_file_name');
                                                                    @endphp
                                                                    {!!$document_file!!}
                                                                </div>
                                                            @else
                                                                <div class="col-md-9" style="margin-top: 3%;"><b>Already Submited</b></div>
                                                            @endif
                                                        </div>
                                                        @endif
                                                    @endforeach
                                                @endif
                                                <?php 
                                            }    
                                            ?>
                                        </div>
                                        <div class="form-actions center">
                                            <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Submit">
                                            <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">
$("input[type='file']").on("change", function () {
    var fp = $(this);
    var lg = fp[0].files.length; 
    var items = fp[0].files;
    var fileSize = 0;
    if (lg > 0) {
        for (var i = 0; i < lg; i++) {
            fileSize = fileSize+items[i].size;
        }
        var sizeInMB = (fileSize / (1024*1024)).toFixed(2);
        //console.log('fileSize==>',fileSize);
        //console.log('sizeInMB==>',sizeInMB + 'MB');
        if(fileSize > 15728640) {
            alert('Please uploaded file less than 15MB. Thanks!!');
            $(this).val('');
        }
    }
});

</script>
@endsection
