<?php

use Illuminate\Support\Facades\Route;
// Admin
use App\Http\Controllers\Admin\Auth\LoginController as AdminLoginController;
use App\Http\Controllers\Admin\AppSettingController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\Auth\ForgotPasswordController as AdminForgotPasswordController;
use App\Http\Controllers\CommonController;
// Customer
use App\Http\Controllers\Customer\Auth\LoginController as CustomerLoginController;
use App\Http\Controllers\Customer\CustomerUserController;
use App\Http\Controllers\Customer\CustomerDocumentController;
use App\Http\Controllers\Customer\Auth\CustomerForgotPasswordController;
use Illuminate\Support\Facades\Mail;
use App\Mail\EmailTemplete;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/test_mail', function() {
    $customer_email = 'bhargav@igentechnolabs.com';
    $mailData = [
        'to_email' => $customer_email,
        'from_email' => 'alpesh.koyani@igentechnolabs.com',
        'title' => 'test',
        'customer_cc_email' => array('maksud@igentechnolabs.com'),
        'body' => 'test mail',
        'subject' => 'test email',
        'files' => array()
    ];
    // $customer_email = array('bhargav@igentechnolabs.com','yogesh.mistry@bakertilly.ug','karthik.belle@bakertilly.ug','rohan.bhaliya@madelineadvisory.in');
    // $mailData = [
    //     'to_email' => $customer_email,
    //     'from_email' => 'alpesh.koyani@igentechnolabs.com',
    //     'title' => 'test',
    //     'customer_cc_email' => array('maksud@igentechnolabs.com','krishna.rathi@bakertilly.ug','aneri.shah@bakertilly.ug'),
    //     'body' => 'test mail',
    //     'subject' => 'test email',
    //     'files' => array()
    // ];
    $smtp_detail = [
        'MAIL_MAILER'     => config('mail.default'),
        'MAIL_HOST'       => config('mail.mailers.smtp.host'),
        'MAIL_PORT'       => config('mail.mailers.smtp.port'),
        'MAIL_USERNAME'   => config('mail.mailers.smtp.username'),
        'MAIL_ENCRYPTION' => config('mail.mailers.smtp.encryption'),
        'MAIL_FROM'       => config('mail.from.address'),
    ];
    echo '<pre>';
      print_r($smtp_detail);
    print_r($mailData);
    echo '</pre>';
    try {
        Mail::to($customer_email)->send(new EmailTemplete($mailData));
        echo "Mail sent successfully to $customer_email";
    } catch (\Exception $e) {
        echo "Mail send failed: " . $e->getMessage();
        dd($e->getMessage()); // Or log more details
    }
    
});
/*
MAIL_MAILER=smtp
MAIL_HOST=bakertilly-ug.com
#MAIL_PORT=465
MAIL_USERNAME=reminder@bakertilly-ug.com
MAIL_PASSWORD=rv!evpnDFHYk
#MAIL_ENCRYPTION=ssl
MAIL_PORT=587
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=reminder@bakertilly-ug.com
MAIL_FROM_NAME="${APP_NAME}"
*/
// Clear all cache:
Route::get('/all-cache', function() {
    Artisan::call('cache:clear');
    Artisan::call('route:cache');
    Artisan::call('config:cache');
    Artisan::call('view:clear');
    return 'all cache has been cleared';
});

// Clear application cache:
Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
});
//Clear route cache:
Route::get('/route-cache', function() {
    Artisan::call('route:cache');
    return 'Routes cache has been cleared';
});
//Clear config cache:
Route::get('/config-cache', function() {
    Artisan::call('config:cache');
    return 'Config cache has been cleared';
}); 
// Clear view cache:
Route::get('/view-clear', function() {
    Artisan::call('view:clear');
    return 'View cache has been cleared';
});

Route::get('/', function () {
    return view('admin.auth.login');
});
Route::get('/generate_card', [CommonController::class, 'generateCard']);
Route::get('employee_detail/{id?}', [CommonController::class, 'getEmployeeDetail'])->name('employee_detail.get');
Route::get('employee_qr_download/{id?}', [CommonController::class, 'getEmployeeQrDownload'])->name('employee_qr_download.get');

Route::get('admin_detail/{id?}', [CommonController::class, 'getAdminDetail'])->name('admin_detail.get');
Route::get('admin_qr_download/{id?}', [CommonController::class, 'getAdminQrDownload'])->name('admin_qr_download.get');

Route::get('birth_email_send', [CommonController::class, 'BirthEmailSend'])->name('birth_email_send.get');
Route::get('getState/{id}', [CommonController::class, 'getState'])->name('state.get');
Route::get('getCity/{id}', [CommonController::class, 'getCity'])->name('city.get');
Route::post('get_group_by_customer/{id}', [CommonController::class, 'getGroupByCustomer'])->name('group_wise_customer.get');
Route::post('get_customer_selected', [CommonController::class, 'getCustomerSeleted'])->name('customer_selected.get');
Route::post('get_customer_contact_details', [CommonController::class, 'getCustomerContactDetails'])->name('customer_contact_details.get');
Route::post('get_phone_code_validation', [CommonController::class, 'getPhoneCodeValidation'])->name('get_phone_code_validation.get');
//Route::post('get_group_wise_customer', [CommonController::class, 'getGroupWiseCustomer'])->name('group_wise_customer.get');
Route::post('get_assignment_by_document/{id}', [CommonController::class, 'getAssignmentByDocument'])->name('assignment_wise_document.get');
Route::get('reminder_send', [CommonController::class, 'ReminderSend'])->name('reminder_send.get');
Route::get('scheduler_reminder_move', [CommonController::class, 'SchedulerReminderMove'])->name('scheduler_reminder_move.get');
Route::get('upload_document/{reminder_id}',[CommonController::class,'detail'])->name('upload.document');
Route::post('upload_document/{reminder_id}',[CommonController::class,'postdetail'])->name('upload.postdocument');
Route::prefix('admin')->group(function () {
        Route::get('forget', [AdminForgotPasswordController::class, 'emailView'])->name('forget.get');
        Route::post('password/email', [AdminForgotPasswordController::class, 'password_email'])->name('password.email');
        Route::get('reset-password/{token}', [AdminForgotPasswordController::class, 'showResetPasswordForm'])->name('reset.password.get');
        Route::post('reset-password', [AdminForgotPasswordController::class, 'submitResetPasswordForm'])->name('reset.password.post');
        Route::post('forget_password', [AdminForgotPasswordController::class, 'forgetPassword']); 
        Route::post('change-password',[AdminForgotPasswordController::class,'updatepassword']);
        
        Route::middleware(['auth.admin'])->group(function () {
        
        Route::get('dashboard', [DashboardController::class, 'dashboard'])->name('admin.dashboard');
        Route::get('dashboard/document_uploaded', [DashboardController::class, 'documentUploaded'])->name('admin.dashboard.document_uploaded');
        Route::get('dashboard/document_accept/{id}', [DashboardController::class, 'documentAccept'])->name('admin.dashboard.document_accept');
        Route::post('dashboard/document_reject/{id}', [DashboardController::class, 'documentReject'])->name('admin.dashboard.document_reject');

        Route::get('/change-password', array('as' => 'changePassword', 'uses'=>'App\Http\Controllers\Admin\UserController@changePassword'));
        Route::post('/change-password', array('as' => 'post.changePassword', 'uses'=>'App\Http\Controllers\Admin\UserController@postchangePassword'));
        
        Route::get('app_setting', [AppSettingController::class, 'edit'])->name('app_setting.index');    
        Route::post('app_setting_update', [AppSettingController::class, 'update'])->name('app_setting.update');    
        
        Route::resource('country','App\Http\Controllers\Admin\CountryController');
        Route::get('country/{id}/active', array('as' => 'active.country', 'uses'=>'App\Http\Controllers\Admin\CountryController@setActivate'));
        Route::get('country/{id}/inactive', array('as' => 'inactive.country', 'uses'=>'App\Http\Controllers\Admin\CountryController@setInactivate'));

        Route::resource('state','App\Http\Controllers\Admin\StateController');
        Route::get('state/{id}/active', array('as' => 'active.state', 'uses'=>'App\Http\Controllers\Admin\StateController@setActivate'));
        Route::get('state/{id}/inactive', array('as' => 'inactive.state', 'uses'=>'App\Http\Controllers\Admin\StateController@setInactivate'));

        Route::resource('city','App\Http\Controllers\Admin\CityController');
        Route::get('city/{id}/active', array('as' => 'active.city', 'uses'=>'App\Http\Controllers\Admin\CityController@setActivate'));
        Route::get('city/{id}/inactive', array('as' => 'inactive.city', 'uses'=>'App\Http\Controllers\Admin\CityController@setInactivate'));

        // User Management
        Route::get('admin/user',array('as' => 'admin.user.index', 'uses'=>'App\Http\Controllers\Admin\AdminUserController@index'));
        Route::get('admin/user/create',array('as' => 'admin.user.create', 'uses'=>'App\Http\Controllers\Admin\AdminUserController@create'));
        Route::post('admin/user/store',array('as' => 'admin.user.store', 'uses'=>'App\Http\Controllers\Admin\AdminUserController@store'));
        Route::get('admin/user/edit/{id}',array('as' => 'admin.user.edit', 'uses'=>'App\Http\Controllers\Admin\AdminUserController@edit'));
        Route::get('admin/user/show/{id}',array('as' => 'admin.user.show', 'uses'=>'App\Http\Controllers\Admin\AdminUserController@show'));
        Route::post('admin/user/update',array('as' => 'admin.user.update', 'uses'=>'App\Http\Controllers\Admin\AdminUserController@update'));
        Route::delete('admin/user/delete/{id}',array('as' => 'admin.user.destroy', 'uses'=>'App\Http\Controllers\Admin\AdminUserController@destroy'));
        Route::get('admin/user/{id}/active', array('as' => 'admin.user.active', 'uses'=>'App\Http\Controllers\Admin\AdminUserController@setActivate'));
        Route::get('admin/user/{id}/inactive', array('as' => 'admin.user.inactive', 'uses'=>'App\Http\Controllers\Admin\AdminUserController@setInactivate'));
        
        // Employee User Management
        Route::get('employee/user',array('as' => 'employee.user.index', 'uses'=>'App\Http\Controllers\Admin\EmployeeUserController@index'));
        Route::get('employee/user/create',array('as' => 'employee.user.create', 'uses'=>'App\Http\Controllers\Admin\EmployeeUserController@create'));
        Route::post('employee/user/store',array('as' => 'employee.user.store', 'uses'=>'App\Http\Controllers\Admin\EmployeeUserController@store'));
		Route::get('employee/user/edit/{id}',array('as' => 'employee.user.edit', 'uses'=>'App\Http\Controllers\Admin\EmployeeUserController@edit'));
        Route::post('employee/user/update',array('as' => 'employee.user.update', 'uses'=>'App\Http\Controllers\Admin\EmployeeUserController@update'));
        Route::get('employee/user/show/{id}',array('as' => 'employee.user.show', 'uses'=>'App\Http\Controllers\Admin\EmployeeUserController@show'));

        // Customer User Management
        Route::get('customer/user',array('as' => 'customer.user.index', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@index'));
        Route::get('customer/user/create',array('as' => 'customer.user.create', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@create'));
        Route::post('customer/user/store',array('as' => 'customer.user.store', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@store'));
		Route::get('customer/user/import',array('as' => 'customer.user.import', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@importcreate'));
        Route::post('customer/user/import',array('as' => 'customer.user.importstore', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@importstore'));
        Route::get('customer/user/edit/{id}',array('as' => 'customer.user.edit', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@edit'));
        Route::get('customer/user/show/{id}',array('as' => 'customer.user.show', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@show'));
        Route::get('customer/user/emailtrack/{id}',array('as' => 'customer.user.emailtrack', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@EmailTrack'));
        Route::post('customer/user/update',array('as' => 'customer.user.update', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@update'));
        Route::delete('customer/user/delete/{id}',array('as' => 'customer.user.destroy', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@destroy'));
        Route::get('customer/user/{id}/active', array('as' => 'customer.user.active', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@setActivate'));
        Route::get('customer/user/{id}/inactive', array('as' => 'customer.user.inactive', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@setInactivate'));
        Route::get('customer/user/reminder/{id}',array('as' => 'customer.user.reminder', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@reminder'));
        Route::get('customer/user/reminder_detail/{customer_id}/{reminder_id}',array('as' => 'customer.user.reminder_detail', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@reminderDetail'));
        Route::post('customer/user/reminder_detail/{customer_id}/{reminder_id}',array('as' => 'customer.user.srote_reminder_detail', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@storeReminderDetail'));
        Route::get('customer/user/reminder_send/{customer_id}/{reminder_id}',array('as' => 'customer.user.reminder_send', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@reminderSend'));
        Route::get('customer/user/document_uploaded/{customer_id}',array('as' => 'customer.user.document_uploaded', 'uses'=>'App\Http\Controllers\Admin\CustomerUserController@documentUploaded'));
        // Reminder Management
        Route::get('reminder',array('as' => 'reminder.index', 'uses'=>'App\Http\Controllers\Admin\ReminderController@index'));
        Route::get('reminder/create',array('as' => 'reminder.create', 'uses'=>'App\Http\Controllers\Admin\ReminderController@create'));
        Route::post('reminder/store',array('as' => 'reminder.store', 'uses'=>'App\Http\Controllers\Admin\ReminderController@store'));
        Route::get('reminder/edit/{id}',array('as' => 'reminder.edit', 'uses'=>'App\Http\Controllers\Admin\ReminderController@edit'));
        Route::get('reminder/show/{id}',array('as' => 'reminder.show', 'uses'=>'App\Http\Controllers\Admin\ReminderController@show'));
        Route::post('reminder/update',array('as' => 'reminder.update', 'uses'=>'App\Http\Controllers\Admin\ReminderController@update'));
        Route::delete('reminder/delete/{id}',array('as' => 'reminder.destroy', 'uses'=>'App\Http\Controllers\Admin\ReminderController@destroy'));
        Route::get('reminder/{id}/active', array('as' => 'reminder.active', 'uses'=>'App\Http\Controllers\Admin\ReminderController@setActivate'));
        Route::get('reminder/{id}/inactive', array('as' => 'reminder.inactive', 'uses'=>'App\Http\Controllers\Admin\ReminderController@setInactivate'));

        // Scheduler Reminder Management
        Route::get('scheduler_reminder',array('as' => 'scheduler_reminder.index', 'uses'=>'App\Http\Controllers\Admin\SchedulerReminderController@index'));
        Route::get('scheduler_reminder/create',array('as' => 'scheduler_reminder.create', 'uses'=>'App\Http\Controllers\Admin\SchedulerReminderController@create'));
        Route::post('scheduler_reminder/store',array('as' => 'scheduler_reminder.store', 'uses'=>'App\Http\Controllers\Admin\SchedulerReminderController@store'));
        Route::get('scheduler_reminder/edit/{id}',array('as' => 'scheduler_reminder.edit', 'uses'=>'App\Http\Controllers\Admin\SchedulerReminderController@edit'));
        Route::get('scheduler_reminder/show/{id}',array('as' => 'scheduler_reminder.show', 'uses'=>'App\Http\Controllers\Admin\SchedulerReminderController@show'));
        Route::post('scheduler_reminder/update',array('as' => 'scheduler_reminder.update', 'uses'=>'App\Http\Controllers\Admin\SchedulerReminderController@update'));
        Route::delete('scheduler_reminder/delete/{id}',array('as' => 'scheduler_reminder.destroy', 'uses'=>'App\Http\Controllers\Admin\SchedulerReminderController@destroy'));
        Route::get('scheduler_reminder/{id}/active', array('as' => 'scheduler_reminder.active', 'uses'=>'App\Http\Controllers\Admin\SchedulerReminderController@setActivate'));
        Route::get('scheduler_reminder/{id}/inactive', array('as' => 'scheduler_reminder.inactive', 'uses'=>'App\Http\Controllers\Admin\SchedulerReminderController@setInactivate'));

        // Heading Management
        Route::get('heading',array('as' => 'heading.index', 'uses'=>'App\Http\Controllers\Admin\HeadingController@index'));
        Route::get('heading/create',array('as' => 'heading.create', 'uses'=>'App\Http\Controllers\Admin\HeadingController@create'));
        Route::post('heading/store',array('as' => 'heading.store', 'uses'=>'App\Http\Controllers\Admin\HeadingController@store'));
        Route::get('heading/edit/{id}',array('as' => 'heading.edit', 'uses'=>'App\Http\Controllers\Admin\HeadingController@edit'));
        Route::get('heading/show/{id}',array('as' => 'heading.show', 'uses'=>'App\Http\Controllers\Admin\HeadingController@show'));
        Route::post('heading/update',array('as' => 'heading.update', 'uses'=>'App\Http\Controllers\Admin\HeadingController@update'));
        Route::delete('heading/delete/{id}',array('as' => 'heading.destroy', 'uses'=>'App\Http\Controllers\Admin\HeadingController@destroy'));
        Route::get('heading/{id}/active', array('as' => 'heading.active', 'uses'=>'App\Http\Controllers\Admin\HeadingController@setActivate'));
        Route::get('heading/{id}/inactive', array('as' => 'heading.inactive', 'uses'=>'App\Http\Controllers\Admin\HeadingController@setInactivate'));

        // Assignment Management
        Route::get('assignment',array('as' => 'assignment.index', 'uses'=>'App\Http\Controllers\Admin\AssignmentController@index'));
        Route::get('assignment/create',array('as' => 'assignment.create', 'uses'=>'App\Http\Controllers\Admin\AssignmentController@create'));
        Route::post('assignment/store',array('as' => 'assignment.store', 'uses'=>'App\Http\Controllers\Admin\AssignmentController@store'));
        Route::get('assignment/edit/{id}',array('as' => 'assignment.edit', 'uses'=>'App\Http\Controllers\Admin\AssignmentController@edit'));
        Route::get('assignment/show/{id}',array('as' => 'assignment.show', 'uses'=>'App\Http\Controllers\Admin\AssignmentController@show'));
        Route::post('assignment/update',array('as' => 'assignment.update', 'uses'=>'App\Http\Controllers\Admin\AssignmentController@update'));
        Route::delete('assignment/delete/{id}',array('as' => 'assignment.destroy', 'uses'=>'App\Http\Controllers\Admin\AssignmentController@destroy'));
        Route::get('assignment/{id}/active', array('as' => 'assignment.active', 'uses'=>'App\Http\Controllers\Admin\AssignmentController@setActivate'));
        Route::get('assignment/{id}/inactive', array('as' => 'assignment.inactive', 'uses'=>'App\Http\Controllers\Admin\AssignmentController@setInactivate'));

        // Dodument Management
        Route::get('reminder/document',array('as' => 'reminder.document.index', 'uses'=>'App\Http\Controllers\Admin\ReminderController@documentUploaded'));

        // Document Management
        Route::get('document',array('as' => 'document.index', 'uses'=>'App\Http\Controllers\Admin\DocumentController@index'));
        Route::get('document/create',array('as' => 'document.create', 'uses'=>'App\Http\Controllers\Admin\DocumentController@create'));
        Route::post('document/store',array('as' => 'document.store', 'uses'=>'App\Http\Controllers\Admin\DocumentController@store'));
        Route::get('document/edit/{id}',array('as' => 'document.edit', 'uses'=>'App\Http\Controllers\Admin\DocumentController@edit'));
        Route::get('document/show/{id}',array('as' => 'document.show', 'uses'=>'App\Http\Controllers\Admin\DocumentController@show'));
        Route::get('document/docs_sample/{id}',array('as' => 'document.docs_sample', 'uses'=>'App\Http\Controllers\Admin\DocumentController@DocSample'));
        Route::post('document/update',array('as' => 'document.update', 'uses'=>'App\Http\Controllers\Admin\DocumentController@update'));
        Route::delete('document/delete/{id}',array('as' => 'document.destroy', 'uses'=>'App\Http\Controllers\Admin\DocumentController@destroy'));
        Route::get('document/{id}/active', array('as' => 'document.active', 'uses'=>'App\Http\Controllers\Admin\DocumentController@setActivate'));
        Route::get('document/{id}/inactive', array('as' => 'document.inactive', 'uses'=>'App\Http\Controllers\Admin\DocumentController@setInactivate'));

        // Templete Management
        Route::get('templete',array('as' => 'templete.index', 'uses'=>'App\Http\Controllers\Admin\DocumentController@templeteindex'));

        // Group Management
        Route::get('group',array('as' => 'group.index', 'uses'=>'App\Http\Controllers\Admin\GroupController@index'));
        Route::get('group/create',array('as' => 'group.create', 'uses'=>'App\Http\Controllers\Admin\GroupController@create'));
        Route::post('group/store',array('as' => 'group.store', 'uses'=>'App\Http\Controllers\Admin\GroupController@store'));
        Route::get('group/edit/{id}',array('as' => 'group.edit', 'uses'=>'App\Http\Controllers\Admin\GroupController@edit'));
        Route::get('group/show/{id}',array('as' => 'group.show', 'uses'=>'App\Http\Controllers\Admin\GroupController@show'));
        Route::post('group/update',array('as' => 'group.update', 'uses'=>'App\Http\Controllers\Admin\GroupController@update'));
        Route::delete('group/delete/{id}',array('as' => 'group.destroy', 'uses'=>'App\Http\Controllers\Admin\GroupController@destroy'));
        Route::get('group/{id}/active', array('as' => 'group.active', 'uses'=>'App\Http\Controllers\Admin\GroupController@setActivate'));
        Route::get('group/{id}/inactive', array('as' => 'group.inactive', 'uses'=>'App\Http\Controllers\Admin\GroupController@setInactivate'));

        // Content Management
        Route::get('content',array('as' => 'content.index', 'uses'=>'App\Http\Controllers\Admin\ContentController@index'));
        Route::get('content/create',array('as' => 'content.create', 'uses'=>'App\Http\Controllers\Admin\ContentController@create'));
        Route::post('content/store',array('as' => 'content.store', 'uses'=>'App\Http\Controllers\Admin\ContentController@store'));
        Route::get('content/edit/{id}',array('as' => 'content.edit', 'uses'=>'App\Http\Controllers\Admin\ContentController@edit'));
        Route::get('content/show/{id}',array('as' => 'content.show', 'uses'=>'App\Http\Controllers\Admin\ContentController@show'));
        Route::post('content/update',array('as' => 'content.update', 'uses'=>'App\Http\Controllers\Admin\ContentController@update'));
        Route::delete('content/delete/{id}',array('as' => 'content.destroy', 'uses'=>'App\Http\Controllers\Admin\ContentController@destroy'));
        Route::get('content/{id}/active', array('as' => 'content.active', 'uses'=>'App\Http\Controllers\Admin\ContentController@setActivate'));
        Route::get('content/{id}/inactive', array('as' => 'content.inactive', 'uses'=>'App\Http\Controllers\Admin\ContentController@setInactivate'));

        // Email Content Management
        Route::get('email_content',array('as' => 'email_content.index', 'uses'=>'App\Http\Controllers\Admin\EmailContentController@index'));
        Route::get('email_content/create',array('as' => 'email_content.create', 'uses'=>'App\Http\Controllers\Admin\EmailContentController@create'));
        Route::post('email_content/store',array('as' => 'email_content.store', 'uses'=>'App\Http\Controllers\Admin\EmailContentController@store'));
        Route::get('email_content/edit/{id}',array('as' => 'email_content.edit', 'uses'=>'App\Http\Controllers\Admin\EmailContentController@edit'));
        Route::get('email_content/show/{id}',array('as' => 'email_content.show', 'uses'=>'App\Http\Controllers\Admin\EmailContentController@show'));
        Route::post('email_content/update',array('as' => 'email_content.update', 'uses'=>'App\Http\Controllers\Admin\EmailContentController@update'));
        Route::delete('email_content/delete/{id}',array('as' => 'email_content.destroy', 'uses'=>'App\Http\Controllers\Admin\EmailContentController@destroy'));
        Route::get('email_content/{id}/active', array('as' => 'email_content.active', 'uses'=>'App\Http\Controllers\Admin\EmailContentController@setActivate'));
        Route::get('email_content/{id}/inactive', array('as' => 'email_content.inactive', 'uses'=>'App\Http\Controllers\Admin\EmailContentController@setInactivate'));
        Route::get('email_content_image/{id}/delete', array('as' => 'email_content.image_delete', 'uses'=>'App\Http\Controllers\Admin\EmailContentController@ImageDelete'));

        // Mass Email Management
        Route::get('mass_email',array('as' => 'mass_email.index', 'uses'=>'App\Http\Controllers\Admin\MassEmailController@index'));
        Route::get('mass_email/create',array('as' => 'mass_email.create', 'uses'=>'App\Http\Controllers\Admin\MassEmailController@create'));
        Route::post('mass_email/store',array('as' => 'mass_email.store', 'uses'=>'App\Http\Controllers\Admin\MassEmailController@store'));
        Route::get('mass_email/show/{id}',array('as' => 'mass_email.show', 'uses'=>'App\Http\Controllers\Admin\MassEmailController@show'));
        Route::get('mass_email/re_send/{id}',array('as' => 'mass_email.re_send', 'uses'=>'App\Http\Controllers\Admin\MassEmailController@Resend'));

        // Currency Management
        Route::get('currency',array('as' => 'currency.index', 'uses'=>'App\Http\Controllers\Admin\CurrencyController@index'));
        Route::get('currency/create',array('as' => 'currency.create', 'uses'=>'App\Http\Controllers\Admin\CurrencyController@create'));
        Route::post('currency/store',array('as' => 'currency.store', 'uses'=>'App\Http\Controllers\Admin\CurrencyController@store'));
        Route::get('currency/edit/{id}',array('as' => 'currency.edit', 'uses'=>'App\Http\Controllers\Admin\CurrencyController@edit'));
        Route::get('currency/show/{id}',array('as' => 'currency.show', 'uses'=>'App\Http\Controllers\Admin\CurrencyController@show'));
        Route::post('currency/update',array('as' => 'currency.update', 'uses'=>'App\Http\Controllers\Admin\CurrencyController@update'));
        Route::delete('currency/delete/{id}',array('as' => 'currency.destroy', 'uses'=>'App\Http\Controllers\Admin\CurrencyController@destroy'));
        Route::get('currency/{id}/active', array('as' => 'currency.active', 'uses'=>'App\Http\Controllers\Admin\CurrencyController@setActivate'));
        Route::get('currency/{id}/inactive', array('as' => 'currency.inactive', 'uses'=>'App\Http\Controllers\Admin\CurrencyController@setInactivate'));

        // Service Management
        Route::get('service',array('as' => 'service.index', 'uses'=>'App\Http\Controllers\Admin\ServiceController@index'));
        Route::get('service/create',array('as' => 'service.create', 'uses'=>'App\Http\Controllers\Admin\ServiceController@create'));
        Route::post('service/store',array('as' => 'service.store', 'uses'=>'App\Http\Controllers\Admin\ServiceController@store'));
        Route::get('service/edit/{id}',array('as' => 'service.edit', 'uses'=>'App\Http\Controllers\Admin\ServiceController@edit'));
        Route::get('service/show/{id}',array('as' => 'service.show', 'uses'=>'App\Http\Controllers\Admin\ServiceController@show'));
        Route::post('service/update',array('as' => 'service.update', 'uses'=>'App\Http\Controllers\Admin\ServiceController@update'));
        Route::delete('service/delete/{id}',array('as' => 'service.destroy', 'uses'=>'App\Http\Controllers\Admin\ServiceController@destroy'));
        Route::get('service/{id}/active', array('as' => 'service.active', 'uses'=>'App\Http\Controllers\Admin\ServiceController@setActivate'));
        Route::get('service/{id}/inactive', array('as' => 'service.inactive', 'uses'=>'App\Http\Controllers\Admin\ServiceController@setInactivate'));

        // Department Management
        Route::get('department',array('as' => 'department.index', 'uses'=>'App\Http\Controllers\Admin\DepartmentController@index'));
        Route::get('department/create',array('as' => 'department.create', 'uses'=>'App\Http\Controllers\Admin\DepartmentController@create'));
        Route::post('department/store',array('as' => 'department.store', 'uses'=>'App\Http\Controllers\Admin\DepartmentController@store'));
        Route::get('department/edit/{id}',array('as' => 'department.edit', 'uses'=>'App\Http\Controllers\Admin\DepartmentController@edit'));
        Route::get('department/show/{id}',array('as' => 'department.show', 'uses'=>'App\Http\Controllers\Admin\DepartmentController@show'));
        Route::post('department/update',array('as' => 'department.update', 'uses'=>'App\Http\Controllers\Admin\DepartmentController@update'));
        Route::delete('department/delete/{id}',array('as' => 'department.destroy', 'uses'=>'App\Http\Controllers\Admin\DepartmentController@destroy'));
        Route::get('department/{id}/active', array('as' => 'department.active', 'uses'=>'App\Http\Controllers\Admin\DepartmentController@setActivate'));
        Route::get('department/{id}/inactive', array('as' => 'department.inactive', 'uses'=>'App\Http\Controllers\Admin\DepartmentController@setInactivate'));

        // company Management
        Route::get('company',array('as' => 'company.index', 'uses'=>'App\Http\Controllers\Admin\CompanyController@index'));
        Route::get('company/create',array('as' => 'company.create', 'uses'=>'App\Http\Controllers\Admin\CompanyController@create'));
        Route::post('company/store',array('as' => 'company.store', 'uses'=>'App\Http\Controllers\Admin\CompanyController@store'));
        Route::get('company/edit/{id}',array('as' => 'company.edit', 'uses'=>'App\Http\Controllers\Admin\CompanyController@edit'));
        Route::get('company/show/{id}',array('as' => 'company.show', 'uses'=>'App\Http\Controllers\Admin\CompanyController@show'));
        Route::post('company/update',array('as' => 'company.update', 'uses'=>'App\Http\Controllers\Admin\CompanyController@update'));
        Route::delete('company/delete/{id}',array('as' => 'company.destroy', 'uses'=>'App\Http\Controllers\Admin\CompanyController@destroy'));
        Route::get('company/{id}/active', array('as' => 'company.active', 'uses'=>'App\Http\Controllers\Admin\CompanyController@setActivate'));
        Route::get('company/{id}/inactive', array('as' => 'company.inactive', 'uses'=>'App\Http\Controllers\Admin\CompanyController@setInactivate'));

        // quotation Management
        Route::get('quotation',array('as' => 'quotation.index', 'uses'=>'App\Http\Controllers\Admin\QuotationController@index'));
        Route::get('quotation/create',array('as' => 'quotation.create', 'uses'=>'App\Http\Controllers\Admin\QuotationController@create'));
        Route::post('quotation/store',array('as' => 'quotation.store', 'uses'=>'App\Http\Controllers\Admin\QuotationController@store'));
        Route::get('quotation/edit/{id}',array('as' => 'quotation.edit', 'uses'=>'App\Http\Controllers\Admin\QuotationController@edit'));
        Route::get('quotation/show/{id}',array('as' => 'quotation.show', 'uses'=>'App\Http\Controllers\Admin\QuotationController@show'));
        Route::post('quotation/update',array('as' => 'quotation.update', 'uses'=>'App\Http\Controllers\Admin\QuotationController@update'));
        Route::delete('quotation/delete/{id}',array('as' => 'quotation.destroy', 'uses'=>'App\Http\Controllers\Admin\QuotationController@destroy'));
        Route::get('quotation/{id}/active', array('as' => 'quotation.active', 'uses'=>'App\Http\Controllers\Admin\QuotationController@setActivate'));
        Route::get('quotation/{id}/inactive', array('as' => 'quotation.inactive', 'uses'=>'App\Http\Controllers\Admin\QuotationController@setInactivate'));
        Route::get('quotation/send/{quotation_id}/{customer_id}',array('as' => 'quotation.send', 'uses'=>'App\Http\Controllers\Admin\QuotationController@QuotationSend'));    
    });
    Route::get('login', [AdminLoginController::class, 'showLoginForm'])->name('admin.login');
    Route::post('login', [AdminLoginController::class, 'login'])->name('admin.login.submit');
    Route::post('logout', [AdminLoginController::class, 'logout'])->name('admin.logout');
});


Route::prefix('customer')->group(function () {
    Route::middleware(['auth.customer'])->group(function () {
        Route::get('dashboard', [CustomerLoginController::class, 'dashboard'])->name('customer.dashboard');
      
        Route::get('change-password', [CustomerUserController::class, 'changePassword'])->name('customer.changePassword');
        Route::post('change-password/post', [CustomerUserController::class, 'postchangePassword'])->name('customer.changePassword.post');
        Route::get('profile', [CustomerUserController::class, 'profile'])->name('customer.profile.edit');
        Route::post('profile/update', [CustomerUserController::class, 'profileUpdate'])->name('customer.profile.update');

        // Order
        Route::get('document',[CustomerDocumentController::class,'index'])->name('customer.document.index');
        Route::get('document/detail/{id}',[CustomerDocumentController::class,'detail'])->name('customer.document.detail');
        Route::post('document/detail/{id}',[CustomerDocumentController::class,'postdetail'])->name('customer.document.postdetail');
    });
    

    Route::get('login', [CustomerLoginController::class, 'showLoginForm'])->name('customer.login');
    Route::post('login', [CustomerLoginController::class, 'login'])->name('customer.login.submit');
    Route::get('register', [CustomerLoginController::class, 'showRegisterForm'])->name('customer.register');
    Route::post('register/post', [CustomerLoginController::class, 'register'])->name('customer.register.submit');
    Route::post('logout', [CustomerLoginController::class, 'logout'])->name('customer.logout');
    Route::get('approval/{token}', [CustomerLoginController::class, 'approval'])->name('customer.approval');
    
    Route::get('forget', [CustomerForgotPasswordController::class, 'emailView'])->name('customer.forget.get');
    Route::post('password/email', [CustomerForgotPasswordController::class, 'password_email'])->name('customer.password.email');
    Route::get('reset-password/{token}', [CustomerForgotPasswordController::class, 'showResetPasswordForm'])->name('customer.reset.password.get');
    Route::post('reset-password', [CustomerForgotPasswordController::class, 'submitResetPasswordForm'])->name('customer.reset.password.post');
    Route::post('forget_password', [CustomerForgotPasswordController::class, 'customer.forgetPassword']); 
    Route::post('change-password',[CustomerForgotPasswordController::class,'customer.updatepassword']);
    
});


